/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.attributes;

import java.security.cert.X509Certificate;
import java.util.Date;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.ASN1Set;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DEREncodableVector;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.DERUTCTime;
import kz.gov.pki.kalkan.asn1.DERUTF8String;
import kz.gov.pki.kalkan.asn1.cms.Attribute;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.cms.CMSAttributes;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.jce.X509Principal;
import kz.gov.pki.kalkan.util.encoders.Base64;

public class AttributeBuilder {
    private static final String OCSP_BASIC_RESPONSE_OID = "1.3.6.1.5.5.7.48.1.1";
    private static final String CUSTOM_SHORT_SUBJECT_DN_OID = "1.3.6.1.4.1.6801.2.8";
    private static final String CUSTOM_FILES_NAMES_OID = "1.2.840.113549.1.9.77";
    private ASN1EncodableVector attributes = new ASN1EncodableVector();

    public AttributeTable build() {
        return new AttributeTable((DEREncodableVector)this.attributes);
    }

    public void clear() {
        this.attributes = new ASN1EncodableVector();
    }

    public void addOCSP(byte[] ocspResponse) {
        Attribute Attribute2 = new Attribute(new DERObjectIdentifier(OCSP_BASIC_RESPONSE_OID), (ASN1Set)new DERSet((DEREncodable)new DEROctetString(ocspResponse)));
        this.attributes.add((DEREncodable)Attribute2);
    }

    public void addSubjectDN(X509Certificate certificate) {
        X509Principal subjectDN = (X509Principal)certificate.getSubjectDN();
        Attribute Attribute2 = new Attribute(new DERObjectIdentifier(CUSTOM_SHORT_SUBJECT_DN_OID), (ASN1Set)new DERSet((DEREncodable)subjectDN.getDERObject()));
        this.attributes.add((DEREncodable)Attribute2);
    }

    public void addFilesNames(String filesNames) {
        Attribute Attribute2 = new Attribute(new DERObjectIdentifier(CUSTOM_FILES_NAMES_OID), (ASN1Set)new DERSet((DEREncodable)new DERUTF8String(filesNames)));
        this.attributes.add((DEREncodable)Attribute2);
    }

    public void addSigningTime(Date date) {
        Attribute Attribute2 = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((DEREncodable)new DERUTCTime(date)));
        this.attributes.add((DEREncodable)Attribute2);
    }

    public void addSigningDescription(String description) {
        Attribute Attribute2 = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_signingDescription, (ASN1Set)new DERSet((DEREncodable)new DERUTF8String(description)));
        this.attributes.add((DEREncodable)Attribute2);
    }

    public void addMessageDigest(String signedData) {
        if (signedData != null) {
            Attribute Attribute2 = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DEROctetString(Base64.decode((String)signedData))));
            this.attributes.add((DEREncodable)Attribute2);
        }
    }

    public void addContentType() {
        Attribute Attribute2 = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_contentType, (ASN1Set)new DERSet((DEREncodable)PKCSObjectIdentifiers.data));
        this.attributes.add((DEREncodable)Attribute2);
    }
}

