/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.attributes;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.Date;
import kz.gov.pki.kalkan.asn1.DEREncodableVector;
import kz.gov.pki.kalkan.asn1.DEROutputStream;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.metadoc.ncamodule.core.attributes.AttributeBuilder;

public class EsedoAttributeDirector {
    private AttributeBuilder builder;
    private X509Certificate certificate;
    private byte[] ocspResponse;
    private String filesNames;
    private Date signingTime;
    private String signedData;
    private AttributeTable attributes = null;

    public EsedoAttributeDirector(AttributeBuilder builder, X509Certificate certificate, byte[] ocspResponse, String filesNames, Date signingTime, String signedData) {
        this.builder = builder;
        this.certificate = certificate;
        this.ocspResponse = ocspResponse;
        this.filesNames = filesNames;
        this.signingTime = signingTime;
        this.signedData = signedData;
    }

    private void prepareTable() {
        if (this.attributes == null) {
            this.builder.addOCSP(this.ocspResponse);
            this.builder.addSubjectDN(this.certificate);
            this.builder.addFilesNames(this.filesNames);
            this.builder.addSigningTime(this.signingTime);
            this.builder.addSigningDescription("ESEDO ");
            this.builder.addMessageDigest(this.signedData);
            this.builder.addContentType();
            this.attributes = this.builder.build();
        }
    }

    public byte[] makeAsByteArray() {
        try {
            byte[] var6;
            this.prepareTable();
            DERSet signedAttributes = new DERSet((DEREncodableVector)this.attributes.toASN1EncodableVector());
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            try (DEROutputStream aOut = new DEROutputStream((OutputStream)bOut);){
                aOut.writeObject((Object)signedAttributes);
                byte[] bytes = bOut.toByteArray();
                bOut.close();
                var6 = bytes;
            }
            return var6;
        }
        catch (Exception var18) {
            throw new RuntimeException("Could not build attributes table!", var18);
        }
    }

    public AttributeTable make() {
        try {
            this.prepareTable();
            return this.attributes;
        }
        catch (Exception var2) {
            throw new RuntimeException("Could not build attributes table!", var2);
        }
    }
}

