/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.generators;

import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessable;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessableByteArray;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedDataGenerator;
import kz.gov.pki.kalkan.jce.provider.cms.SignerId;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformation;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformationStore;
import kz.gov.pki.kalkan.ocsp.OCSPResp;
import kz.gov.pki.kalkan.tsp.TimeStampRequest;
import kz.gov.pki.kalkan.tsp.TimeStampResponse;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.metadoc.ncamodule.core.attributes.AttributeBuilder;
import kz.metadoc.ncamodule.core.attributes.EsedoAttributeDirector;
import kz.metadoc.ncamodule.core.generators.SignatureGenerator;
import kz.metadoc.ncamodule.core.keys.KeyLoader;
import kz.metadoc.ncamodule.core.log.LoggingPoint;
import kz.metadoc.ncamodule.core.utils.OCSPUtil;
import kz.metadoc.ncamodule.core.utils.TimeStampToAttributeTableConverter;
import kz.metadoc.ncamodule.core.utils.TimeStampUtil;

public class DefaultSignatureGenerator
implements SignatureGenerator {
    private final String filesNames;

    public DefaultSignatureGenerator(String filesNames) {
        this.filesNames = filesNames;
    }

    @Override
    public String sign(KeyLoader keyLoader, byte[] dataForSign) throws Exception {
        X509Certificate certificate = keyLoader.getCertificate();
        OCSPUtil ocspUtil = new OCSPUtil(certificate);
        OCSPResp ocspResponse = ocspUtil.getOCSPResponse();
        LoggingPoint.log("OCSPResponse: " + Base64.encodeStr((byte[])ocspResponse.getEncoded()));
        Date signTime = OCSPUtil.getProducedDate(ocspResponse);
        this.debugLocalTime(signTime);
        AttributeTable signedAttributesTable = this.createSignedAttributeTable(certificate, ocspResponse.getEncoded(), signTime);
        CertStore chainStore = DefaultSignatureGenerator.createCertStore(certificate);
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        String algorithm = DefaultSignatureGenerator.extractSignAlgorithm(certificate);
        generator.addSigner(keyLoader.getPrivateKey(), certificate, algorithm, signedAttributesTable, (AttributeTable)null);
        generator.addCertificatesAndCRLs(chainStore);
        CMSProcessableByteArray content = new CMSProcessableByteArray(dataForSign);
        try {
            CMSSignedData cmsSignedData = generator.generate((CMSProcessable)content, false, "KALKAN");
            cmsSignedData = this.addUnsignedAttributes(certificate, cmsSignedData);
            byte[] sign = cmsSignedData.getEncoded();
            return Base64.encodeStr((byte[])sign);
        }
        catch (Exception var14) {
            LoggingPoint.log(var14.getMessage());
            throw new Exception("Could not create sign!");
        }
    }

    private CMSSignedData addUnsignedAttributes(X509Certificate certificate, CMSSignedData cmsSignedData) {
        SignerId selector = new SignerId();
        selector.setSerialNumber(certificate.getSerialNumber());
        selector.setIssuer(certificate.getIssuerX500Principal());
        SignerInformation signerInfo = cmsSignedData.getSignerInfos().get(selector);
        Collection signerInfos = cmsSignedData.getSignerInfos().getSigners();
        signerInfos.remove(signerInfo);
        AttributeTable unsignedAttrTable = this.createUnsignedAttributeTable(certificate, signerInfo.getSignature());
        signerInfos.add(SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInfo, (AttributeTable)unsignedAttrTable));
        SignerInformationStore signerInformationStore = new SignerInformationStore(signerInfos);
        return CMSSignedData.replaceSigners((CMSSignedData)cmsSignedData, (SignerInformationStore)signerInformationStore);
    }

    private void debugLocalTime(Date signTime) {
        LoggingPoint.log("signTime: " + signTime.getTime());
        Date currentDate = new Date(System.currentTimeMillis());
        LoggingPoint.log("currentDate: " + currentDate.getTime());
    }

    private AttributeTable createUnsignedAttributeTable(X509Certificate certificate, byte[] dataForSign) {
        try {
            TimeStampUtil tsu = new TimeStampUtil(dataForSign, certificate.getSerialNumber());
            TimeStampRequest tsr = tsu.buildRequest(certificate);
            TimeStampResponse timeStampResponse = tsu.sendRequest(tsr);
            LoggingPoint.log("TSPResponse: " + Base64.encodeStr((byte[])timeStampResponse.getEncoded()));
            timeStampResponse.validate(tsr);
            return TimeStampToAttributeTableConverter.convert(timeStampResponse);
        }
        catch (Exception var6) {
            throw new RuntimeException("Could not create unsigned attributes!", var6);
        }
    }

    private AttributeTable createSignedAttributeTable(X509Certificate certificate, byte[] ocspResponse, Date signingTime) {
        AttributeBuilder builder = new AttributeBuilder();
        EsedoAttributeDirector director = new EsedoAttributeDirector(builder, certificate, ocspResponse, this.filesNames, signingTime, null);
        return director.make();
    }

    private static String extractSignAlgorithm(X509Certificate certificate) {
        String algorithm = certificate.getSigAlgOID().equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId()) ? CMSSignedDataGenerator.DIGEST_SHA1 : (certificate.getSigAlgOID().equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId()) ? CMSSignedDataGenerator.DIGEST_SHA256 : (certificate.getSigAlgOID().equals(KNCAObjectIdentifiers.gost34311_95_with_gost34310_2004.getId()) ? CMSSignedDataGenerator.DIGEST_GOST34311_95 : (certificate.getSigAlgOID().equals(KNCAObjectIdentifiers.gost3411_2015_with_gost3410_2015_512.getId()) ? CMSSignedDataGenerator.DIGEST_GOST3411_2015_512 : CMSSignedDataGenerator.DIGEST_GOST3411_GT)));
        return algorithm;
    }

    private static CertStore createCertStore(X509Certificate certificate) throws Exception {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        list.add(certificate);
        return CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(list), "KALKAN");
    }
}

