/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.keys;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import kz.metadoc.ncamodule.core.ProviderManager;
import kz.metadoc.ncamodule.core.exceptions.KeyLoadException;
import kz.metadoc.ncamodule.core.exceptions.WrongPasswordException;
import kz.metadoc.ncamodule.core.keys.KeyLoader;

public class FileKeyLoader
implements KeyLoader {
    private final X509Certificate certificate;
    private final PrivateKey privateKey;
    private final String alias;

    public FileKeyLoader(byte[] key, String password) throws KeyLoadException, NoSuchProviderException, WrongPasswordException {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12", ProviderManager.getProviderName());
            ByteArrayInputStream keyStream = new ByteArrayInputStream(key);
            keyStore.load(keyStream, password.toCharArray());
            Enumeration<String> aliases = keyStore.aliases();
            String alias = null;
            while (aliases.hasMoreElements()) {
                String value;
                alias = value = aliases.nextElement();
                if (!value.equals("Users private key")) continue;
                break;
            }
            this.privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            this.certificate = (X509Certificate)keyStore.getCertificate(alias);
            this.alias = alias;
        }
        catch (NoSuchProviderException var8) {
            throw var8;
        }
        catch (Exception var9) {
            if (var9.getMessage().contains("wrong password or corrupted file")) {
                throw new WrongPasswordException(var9);
            }
            throw new KeyLoadException("Could not load key!", var9);
        }
    }

    @Override
    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getAlias() {
        return this.alias;
    }
}

