/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.keys;

import java.security.KeyStore;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import kz.gov.pki.kalkan.Storage;
import kz.metadoc.ncamodule.core.exceptions.KeyLoadException;
import kz.metadoc.ncamodule.core.exceptions.WrongPasswordException;
import kz.metadoc.ncamodule.core.keys.KeyLoader;
import kz.metadoc.ncamodule.core.utils.KeyStoreUtil;

public class TokenKeyLoader
implements KeyLoader {
    private X509Certificate certificate;
    private PrivateKey privateKey;

    public TokenKeyLoader(String slot, String password) throws KeyLoadException, NoSuchProviderException, WrongPasswordException {
        try {
            Enumeration<String> aliases;
            Storage storage = Storage.get((String)"AKKaztokenStore");
            Provider providers = Security.getProvider("KALKAN");
            KeyStore keyStore = KeyStoreUtil.getKeyStore(storage, slot, password.toCharArray(), providers);
            try {
                aliases = keyStore.aliases();
            }
            catch (Exception var9) {
                throw new WrongPasswordException(var9);
            }
            while (aliases.hasMoreElements()) {
                String aliasApplicant = aliases.nextElement();
                try {
                    this.privateKey = (PrivateKey)keyStore.getKey(aliasApplicant, password.toCharArray());
                    this.certificate = (X509Certificate)keyStore.getCertificate(aliasApplicant);
                    if (this.privateKey == null || this.certificate == null) {
                        this.privateKey = null;
                        this.certificate = null;
                    }
                    break;
                }
                catch (Exception exception) {}
            }
        }
        catch (NoSuchProviderException | WrongPasswordException var11) {
            throw var11;
        }
        catch (Exception var12) {
            if (var12.getMessage().equals("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c")) {
                throw new WrongPasswordException(var12);
            }
            throw new KeyLoadException("Could not load key!", var12);
        }
    }

    @Override
    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

