/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.utils;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kz.metadoc.ncamodule.core.ProviderManager;
import kz.metadoc.ncamodule.core.exceptions.UnknownCaException;
import kz.metadoc.ncamodule.core.exceptions.certificates.IssuerCertificateNotFoundException;
import kz.metadoc.ncamodule.core.exceptions.certificates.RootCheckCertificateException;
import kz.metadoc.ncamodule.core.utils.CertificateUtil;

public class CertificateChainUtil {
    private static final int MAX_DEPTH_FOR_CA = 5;

    public static List<X509Certificate> getCertificatesChain(X509Certificate certificate) throws RootCheckCertificateException, IssuerCertificateNotFoundException, InvalidKeyException, CertificateException, NoSuchAlgorithmException, SignatureException {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate");
        }
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        int depth = 1;
        while (true) {
            chain.add(certificate);
            if (CertificateUtil.isRoot(certificate) || depth++ >= 5) {
                return chain;
            }
            certificate = CertificateUtil.getIssuerCertificate(certificate);
        }
    }

    public static void validateCertificateChain(X509Certificate targetCertificate, Date signingTime) throws UnknownCaException, RootCheckCertificateException, CertificateNotYetValidException, CertificateExpiredException {
        List<X509Certificate> chain;
        try {
            chain = CertificateChainUtil.getCertificatesChain(targetCertificate);
            for (int certificateIndex = 0; certificateIndex < chain.size() - 1; ++certificateIndex) {
                X509Certificate certificate = chain.get(certificateIndex);
                X509Certificate issuer = chain.get(certificateIndex + 1);
                certificate.verify(issuer.getPublicKey(), ProviderManager.getProviderName());
            }
        }
        catch (Exception var6) {
            throw new UnknownCaException(var6);
        }
        for (X509Certificate certificate : chain) {
            CertificateUtil.validateCertificateExpire(certificate, signingTime);
        }
    }
}

