/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import kz.gov.pki.kalkan.jce.provider.X509CertParser;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.metadoc.ncamodule.core.exceptions.certificates.CertificateConvertException;

public class CertificateConverter {
    public static X509Certificate fromBase64ToCertificate(String certificate) throws CertificateConvertException {
        return CertificateConverter.fromByteArrayToCertificate(Base64.decode((String)certificate));
    }

    public static X509Certificate fromByteArrayToCertificate(byte[] certificate) throws CertificateConvertException {
        try {
            X509CertParser x509CertParser = new X509CertParser();
            ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(certificate);
            x509CertParser.engineInit((InputStream)certificateInputStream);
            return (X509Certificate)x509CertParser.engineRead();
        }
        catch (Exception var3) {
            throw new CertificateConvertException(var3);
        }
    }

    public static String fromCertificateToBase64String(X509Certificate certificate) throws CertificateConvertException {
        try {
            byte[] encoded = certificate.getEncoded();
            return Base64.encodeStr((byte[])encoded);
        }
        catch (Exception var2) {
            throw new CertificateConvertException(var2);
        }
    }
}

