/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.utils;

import java.security.cert.X509Certificate;
import kz.gov.pki.kalkan.asn1.ASN1Object;
import kz.gov.pki.kalkan.asn1.ASN1TaggedObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.x509.TBSCertificateStructure;
import kz.gov.pki.kalkan.asn1.x509.X509Extension;
import kz.metadoc.ncamodule.core.exceptions.certificates.DefectCertificateException;
import kz.metadoc.ncamodule.core.exceptions.certificates.TBSCertificateFormatException;

public class CertificateExtensionsUtil {
    public static final String AUTHORITY_INFO_ACCESS = "1.3.6.1.5.5.7.1.1";
    public static final String AUTHORITY_KEY_IDENTIFIER = "2.5.29.35";

    public static X509Extension getExtensionFromCertificate(X509Certificate certificate, String oid) throws DefectCertificateException {
        X509Extension extension = CertificateExtensionsUtil.extractTBSCertificate(certificate).getExtensions().getExtension(new DERObjectIdentifier(oid));
        if (extension == null) {
            throw new DefectCertificateException("Could not get authority info extension!");
        }
        return extension;
    }

    public static ASN1Object getExtensionObjectFromCertificate(X509Certificate certificate, String oid) throws DefectCertificateException {
        X509Extension extension = CertificateExtensionsUtil.extractTBSCertificate(certificate).getExtensions().getExtension(new DERObjectIdentifier(oid));
        if (extension == null) {
            throw new DefectCertificateException("Could not get authority info extension!");
        }
        return X509Extension.convertValueToObject((X509Extension)extension);
    }

    private static TBSCertificateStructure extractTBSCertificate(X509Certificate targetCertificate) throws TBSCertificateFormatException {
        try {
            byte[] tbsCert = targetCertificate.getTBSCertificate();
            return TBSCertificateStructure.getInstance((Object)ASN1TaggedObject.fromByteArray((byte[])tbsCert));
        }
        catch (Exception var2) {
            throw new TBSCertificateFormatException(var2);
        }
    }
}

