/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.utils;

import java.security.cert.X509Certificate;
import java.util.List;
import kz.metadoc.ncamodule.core.exceptions.certificates.DefectCertificateException;
import kz.metadoc.ncamodule.core.exceptions.verification.CertificatePermissionException;
import kz.metadoc.ncamodule.core.utils.CertificatePermission;
import kz.metadoc.ncamodule.core.utils.CertificatePolicy;
import kz.metadoc.ncamodule.core.utils.CertificateUtil;

public class CertificatePermissionUtil {
    public static final int DIGITAL_SIGNATURE_PERMISSION_INDEX = 0;
    public static final int NON_REPUDIATION_PERMISSION_INDEX = 1;
    public static final int KEY_EENCIPHERMENT_PERMISSION_INDEX = 2;
    public static final int DATA_EENCIPHERMENT_PERMISSION_INDEX = 3;
    public static final int KEY_AGREEMENT_PERMISSION_INDEX = 4;
    public static final int KEY_CERT_SIGN_PERMISSION_INDEX = 5;
    public static final int CRL_SIGN_EENCIPHERMENT_PERMISSION_INDEX = 6;
    public static final int ENCIPHER_ONLY_PERMISSION_INDEX = 6;
    public static final int DECIPHER_ONLY_PERMISSION_INDEX = 6;

    public static void checkPolicies(X509Certificate certificate, CertificatePolicy ... allowedPolicies) throws CertificatePermissionException {
        CertificatePolicy[] var2 = allowedPolicies;
        int var3 = allowedPolicies.length;
        block4: for (int var4 = 0; var4 < var3; ++var4) {
            CertificatePolicy allowedPolicy = var2[var4];
            switch (allowedPolicy) {
                case AUTH: {
                    if (!CertificatePermissionUtil.isKeyForAuth(certificate)) continue block4;
                    return;
                }
                case SIGN: {
                    if (!CertificatePermissionUtil.isKeyForSign(certificate)) continue block4;
                    return;
                }
            }
        }
        throw new CertificatePermissionException();
    }

    public static void checkPermissions(X509Certificate certificate, int ... flags) throws DefectCertificateException, CertificatePermissionException {
        try {
            boolean[] usages = certificate.getKeyUsage();
            int[] var3 = flags;
            int var4 = flags.length;
            for (int var5 = 0; var5 < var4; ++var5) {
                int flag = var3[var5];
                if (usages[flag]) continue;
                throw new CertificatePermissionException();
            }
        }
        catch (CertificatePermissionException var7) {
            throw var7;
        }
        catch (Exception var8) {
            throw new DefectCertificateException(var8);
        }
    }

    public static void checkExtensionPermissions(X509Certificate certificate, CertificatePermission ... flags) throws DefectCertificateException, CertificatePermissionException {
        try {
            List<String> usages = certificate.getExtendedKeyUsage();
            CertificatePermission[] var3 = flags;
            int var4 = flags.length;
            for (int var5 = 0; var5 < var4; ++var5) {
                CertificatePermission flag = var3[var5];
                if (usages.contains(flag.toString())) continue;
                throw new CertificatePermissionException();
            }
        }
        catch (CertificatePermissionException var7) {
            throw var7;
        }
        catch (Exception var8) {
            throw new DefectCertificateException(var8);
        }
    }

    public static void checkOptionalExtensionPermissions(X509Certificate certificate, CertificatePermission ... flags) throws DefectCertificateException, CertificatePermissionException {
        try {
            List<String> usages = certificate.getExtendedKeyUsage();
            CertificatePermission[] var3 = flags;
            int var4 = flags.length;
            for (int var5 = 0; var5 < var4; ++var5) {
                CertificatePermission flag = var3[var5];
                if (!usages.contains(flag.toString())) continue;
                return;
            }
            throw new CertificatePermissionException();
        }
        catch (CertificatePermissionException var7) {
            throw var7;
        }
        catch (Exception var8) {
            throw new DefectCertificateException(var8);
        }
    }

    public static boolean isKeyForSign(X509Certificate certificate) {
        try {
            CertificatePermissionUtil.checkPermissions(certificate, 0, 1);
            return true;
        }
        catch (Exception var2) {
            return false;
        }
    }

    public static boolean isKeyForAuth(X509Certificate certificate) {
        try {
            CertificatePermissionUtil.checkPermissions(certificate, 0, 2);
            return true;
        }
        catch (Exception var2) {
            return CertificateUtil.checkCertficateIssuer(certificate, "CN=\u0423\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u044f\u044e\u0449\u0438\u0439 \u0446\u0435\u043d\u0442\u0440 \u0413\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u043e\u0440\u0433\u0430\u043d\u043e\u0432,O=\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d,C=KZ") || CertificateUtil.checkCertficateIssuer(certificate, "CN=\u0423\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u044f\u044e\u0449\u0438\u0439 \u0446\u0435\u043d\u0442\u0440 \u0413\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u043e\u0440\u0433\u0430\u043d\u043e\u0432,O=\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d,C=KZ");
        }
    }

    public static boolean isEntityOfOrganization(X509Certificate certificate) {
        try {
            CertificatePermissionUtil.checkExtensionPermissions(certificate, CertificatePermission.ENTITY, CertificatePermission.ENTITY_OF_ORGANIZATION);
            return true;
        }
        catch (Exception var2) {
            return false;
        }
    }

    public static boolean isHavePermissionsForSign(X509Certificate certificate) {
        try {
            CertificatePermissionUtil.checkExtensionPermissions(certificate, CertificatePermission.ENTITY);
            CertificatePermissionUtil.checkOptionalExtensionPermissions(certificate, CertificatePermission.ENTITY_WITH_SIGN_PERM, CertificatePermission.TOP_HEAD);
            return true;
        }
        catch (Exception var2) {
            return false;
        }
    }
}

