/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.utils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.function.Predicate;
import javax.security.auth.x500.X500Principal;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.DERSequence;
import kz.gov.pki.kalkan.asn1.DERTaggedObject;
import kz.gov.pki.kalkan.asn1.ocsp.OCSPObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.X509Extension;
import kz.gov.pki.kalkan.util.encoders.Hex;
import kz.metadoc.ncamodule.core.exceptions.certificates.IssuerCertificateNotFoundException;
import kz.metadoc.ncamodule.core.exceptions.certificates.IssuerCertificateSerialnumberNotFoundException;
import kz.metadoc.ncamodule.core.exceptions.certificates.OcspNotFoundInCertificateException;
import kz.metadoc.ncamodule.core.exceptions.certificates.RootCheckCertificateException;
import kz.metadoc.ncamodule.core.utils.CertificateExtensionsUtil;
import kz.metadoc.ncamodule.core.utils.KeyStoreUtil;

public class CertificateUtil {
    public static String getCertificateSerialNumber(X509Certificate targetCertificate) {
        return Hex.encodeStr((byte[])targetCertificate.getSerialNumber().toByteArray());
    }

    public static X509Certificate getIssuerCertificate(X509Certificate targetCertificate) throws IssuerCertificateNotFoundException {
        X500Principal issuerCertificatePrincipal = targetCertificate.getIssuerX500Principal();
        Optional<X509Certificate> issuerCertificate = CertificateUtil.findCertificate(x -> x.getSubjectX500Principal().equals(issuerCertificatePrincipal));
        if (issuerCertificate.isPresent()) {
            return issuerCertificate.get();
        }
        try {
            String issuerSerialNumber = CertificateUtil.getIssuerCertificateSerialNumber(targetCertificate);
            Optional<X509Certificate> issuerCertificateBySerialNumber = CertificateUtil.findCertificate(x -> CertificateUtil.getCertificateSerialNumber(x).equals(issuerSerialNumber));
            if (issuerCertificateBySerialNumber.isPresent()) {
                return issuerCertificateBySerialNumber.get();
            }
        }
        catch (Exception var5) {
            throw new IssuerCertificateNotFoundException(var5);
        }
        throw new IssuerCertificateNotFoundException(issuerCertificatePrincipal.toString());
    }

    private static Optional<X509Certificate> findCertificate(Predicate<? super X509Certificate> predicate) {
        return KeyStoreUtil.getCaCerts().stream().filter(predicate).findFirst();
    }

    public static String getUrlToOcsp(X509Certificate targetCertificate) throws OcspNotFoundInCertificateException {
        try {
            X509Extension extension = CertificateExtensionsUtil.getExtensionFromCertificate(targetCertificate, "1.3.6.1.5.5.7.1.1");
            return CertificateUtil.getUrlToOcspFromAuthorityInfoAccessExtension(extension);
        }
        catch (Exception var2) {
            throw new OcspNotFoundInCertificateException(var2);
        }
    }

    public static String getIssuerCertificateSerialNumber(X509Certificate targetCertificate) throws IssuerCertificateSerialnumberNotFoundException {
        try {
            DERSequence extension = (DERSequence)CertificateExtensionsUtil.getExtensionObjectFromCertificate(targetCertificate, "2.5.29.35");
            DERTaggedObject taggedObject = (DERTaggedObject)extension.getObjectAt(2);
            DEROctetString str = (DEROctetString)taggedObject.getObject();
            return Hex.encodeStr((byte[])str.getOctets());
        }
        catch (Exception var4) {
            throw new IssuerCertificateSerialnumberNotFoundException(var4);
        }
    }

    public static boolean isRoot(X509Certificate targetCertificate) throws RootCheckCertificateException {
        try {
            return targetCertificate.getIssuerX500Principal().equals(targetCertificate.getSubjectX500Principal());
        }
        catch (Exception var2) {
            throw new RootCheckCertificateException(var2);
        }
    }

    public static void validateCertificateExpire(X509Certificate certificate, Date signingTime) throws CertificateNotYetValidException, CertificateExpiredException {
        certificate.checkValidity(signingTime);
    }

    public static String getCertificateIssuerNameRFC2253(X509Certificate certificate) {
        X500Principal p = certificate.getIssuerX500Principal();
        return p.getName("RFC2253");
    }

    public static boolean checkCertficateIssuer(X509Certificate certificate, String issuer) {
        return CertificateUtil.getCertificateIssuerNameRFC2253(certificate).equals(issuer);
    }

    private static String getUrlToOcspFromAuthorityInfoAccessExtension(X509Extension extension) throws Exception {
        ASN1Sequence asn1Object = ASN1Sequence.getInstance((Object)DERSequence.fromByteArray((byte[])extension.getValue().getOctets()));
        ASN1Sequence asn1Sequence = null;
        int objectSize = Collections.list(asn1Object.getObjects()).size();
        for (int i = 0; i < objectSize; ++i) {
            ASN1Sequence sequence = (ASN1Sequence)asn1Object.getObjectAt(i);
            String oid = ((DERObjectIdentifier)sequence.getObjectAt(0)).getId();
            if (!oid.equals(OCSPObjectIdentifiers.id_pkix_ocsp.getId())) continue;
            asn1Sequence = sequence;
            break;
        }
        if (asn1Sequence == null) {
            throw new Exception("OCSP Object Identifier not found");
        }
        return CertificateUtil.parseUrl(asn1Sequence);
    }

    private static String parseUrl(DEREncodable derEncodable) throws IOException {
        ASN1Sequence enumeratorCurrent = ASN1Sequence.getInstance((Object)derEncodable);
        DEROctetString enumerator1 = (DEROctetString)((DERTaggedObject)enumeratorCurrent.getObjectAt(1)).getObject();
        return new String(enumerator1.getEncoded(), StandardCharsets.UTF_8).substring(2);
    }
}

