/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.utils;

import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessable;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessableByteArray;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.SignerId;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformation;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformationStore;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.metadoc.ncamodule.core.ProviderManager;
import kz.metadoc.ncamodule.core.exceptions.SignatureDamagedException;

public class CmsUtil {
    public static List<X509Certificate> getCertificatesFromSignature(String sign) throws SignatureDamagedException {
        byte[] decodedSignature = Base64.decode((String)sign);
        CMSSignedData cms = CmsUtil.updateDataInCMS(decodedSignature, new byte[0]);
        Map<SignerInformation, X509Certificate> signersMap = CmsUtil.getCertificatesFromSignature(cms);
        return Arrays.asList(signersMap.values().toArray()).stream().map(x -> (X509Certificate)x).collect(Collectors.toList());
    }

    public static CMSSignedData updateDataInCMS(byte[] signature, byte[] signedData) throws SignatureDamagedException {
        try {
            boolean isAttachedContent;
            CMSSignedData cms = new CMSSignedData(signature);
            boolean bl = isAttachedContent = cms.getSignedContent() != null;
            if (isAttachedContent) {
                cms = new CMSSignedData(cms.getEncoded());
            } else {
                CMSProcessableByteArray data = new CMSProcessableByteArray(signedData);
                cms = new CMSSignedData((CMSProcessable)data, cms.getEncoded());
            }
            return cms;
        }
        catch (Exception var5) {
            throw new SignatureDamagedException("Could not input signedData in CMS!", var5);
        }
    }

    public static Map<SignerInformation, X509Certificate> getCertificatesFromSignature(CMSSignedData cms) throws SignatureDamagedException {
        try {
            SignerInformationStore signers = cms.getSignerInfos();
            CertStore certs = cms.getCertificatesAndCRLs("Collection", ProviderManager.getProvider().getName());
            HashMap<SignerInformation, X509Certificate> signersMap = new HashMap<SignerInformation, X509Certificate>();
            for (Object signerObject : signers.getSigners()) {
                SignerInformation signer = (SignerInformation)signerObject;
                SignerId signerId = signer.getSID();
                certs.getCertificates((CertSelector)signerId).forEach(x -> {
                    X509Certificate var10000 = signersMap.put(signer, (X509Certificate)x);
                });
            }
            return signersMap;
        }
        catch (Exception var8) {
            throw new SignatureDamagedException("Could not get certificates in signature!", var8);
        }
    }
}

