/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.utils;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kz.gov.pki.kalkan.asn1.ASN1Object;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.DERSequence;
import kz.gov.pki.kalkan.asn1.DERTaggedObject;
import kz.gov.pki.kalkan.jce.provider.JDKX509CertificateFactory;
import kz.gov.pki.kalkan.jce.provider.X509CRLObject;
import kz.gov.pki.kalkan.util.Strings;
import kz.metadoc.ncamodule.core.exceptions.CRLDownloadException;

public class CrlService {
    private static final String FRESHEST_CRL = "2.5.29.46";
    private static final String CRL_DISTRIBUTION_POINT = "2.5.29.31";
    private static final Map<String, X509CRLObject> cachedCRLs = new ConcurrentHashMap<String, X509CRLObject>();
    private static String defaultUrlToCrl = null;
    private String urlToCrl;
    private String urlToFreshestCrl;

    public CrlService(String urlToCrl, String urlToFreshestCrl) {
        this.urlToCrl = urlToCrl;
        this.urlToFreshestCrl = urlToFreshestCrl;
    }

    public CrlService(X509Certificate certificate) throws CRLException {
        this.urlToCrl = this.getCrlUrlFromCertificate(certificate);
        try {
            this.urlToFreshestCrl = this.getCrlDeltaUrlFromCertificate(certificate);
        }
        catch (Exception var3) {
            this.urlToFreshestCrl = null;
        }
    }

    public static void setDefaultUrlToCrl(String defaultUrlToCrl) {
        CrlService.defaultUrlToCrl = defaultUrlToCrl;
    }

    private String getCrlUrlFromCertificate(X509Certificate certificate) throws CRLException {
        return this.getCrlUrlFromCertificate(certificate, CRL_DISTRIBUTION_POINT);
    }

    private String getCrlDeltaUrlFromCertificate(X509Certificate certificate) throws CRLException {
        return this.getCrlUrlFromCertificate(certificate, FRESHEST_CRL);
    }

    private String getCrlUrlFromCertificate(X509Certificate certificate, String extensionId) throws CRLException {
        try {
            byte[] crlDistributionPointsExtension = certificate.getExtensionValue(extensionId);
            if (crlDistributionPointsExtension == null) {
                return defaultUrlToCrl;
            }
            DEROctetString s = (DEROctetString)ASN1Object.fromByteArray((byte[])crlDistributionPointsExtension);
            DERSequence d = (DERSequence)ASN1Object.fromByteArray((byte[])s.getOctets());
            DERTaggedObject dto = (DERTaggedObject)((DERSequence)d.getObjectAt(0)).getObjectAt(0);
            DERTaggedObject dto2 = (DERTaggedObject)dto.getObject();
            if (dto2.getObject() instanceof DERSequence) {
                DERSequence sequence = (DERSequence)dto2.getObject();
                if (sequence.size() == 0) {
                    throw new RuntimeException("Could not find CRL url in certificate!");
                }
                return this.getUrlFromDerTeggetObject((DERTaggedObject)sequence.getObjectAt(0));
            }
            return this.getUrlFromDerTeggetObject((DERTaggedObject)dto2.getObject());
        }
        catch (Exception var9) {
            throw new CRLException("Could not parse crl address from crt file!");
        }
    }

    private String getUrlFromDerTeggetObject(DERTaggedObject obj) {
        DEROctetString s = (DEROctetString)obj.getObject();
        String url = Strings.fromUTF8ByteArray((byte[])s.getOctets());
        return url.split("\n")[0];
    }

    public String getUrlToCrl() {
        return this.urlToCrl;
    }

    public String getUrlToFreshestCrl() {
        return this.urlToFreshestCrl;
    }

    public X509CRLObject getCRL() throws CRLDownloadException {
        return this.urlToCrl == null ? null : this.getCrlByUrl(this.urlToCrl);
    }

    public X509CRLObject getFreshestCRL() throws CRLDownloadException {
        return this.urlToFreshestCrl == null ? null : this.getCrlByUrl(this.urlToFreshestCrl);
    }

    private X509CRLObject getCrlByUrl(String url) throws CRLDownloadException {
        X509CRLObject crl = cachedCRLs.get(url);
        if (crl == null || crl.getNextUpdate().before(new Date())) {
            crl = this.downloadCrlByUrl(url);
            cachedCRLs.put(url, crl);
        }
        return crl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509CRLObject downloadCrlByUrl(String url) throws CRLDownloadException {
        try {
            X509CRLObject var7;
            URL crlUrl = new URL(url);
            HttpURLConnection con = (HttpURLConnection)crlUrl.openConnection();
            con.setRequestMethod("GET");
            try (InputStream in = con.getInputStream();){
                CRL crl = new JDKX509CertificateFactory().engineGenerateCRL(in);
                var7 = (X509CRLObject)crl;
            }
            finally {
                con.disconnect();
            }
            return var7;
        }
        catch (Exception var28) {
            throw new CRLDownloadException(var28);
        }
    }
}

