/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.utils;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERInteger;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.ocsp.CertID;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.asn1.x509.SubjectPublicKeyInfo;
import kz.gov.pki.kalkan.jce.PrincipalUtil;
import kz.gov.pki.kalkan.jce.X509Principal;
import kz.gov.pki.kalkan.ocsp.CertificateID;
import kz.gov.pki.kalkan.ocsp.OCSPException;

final class GostCertID {
    private final CertID id;

    public GostCertID(X509Certificate issuerCert, BigInteger number) throws OCSPException {
        AlgorithmIdentifier hashAlg = new AlgorithmIdentifier(new DERObjectIdentifier(CertificateID.HASH_GOST34311), (DEREncodable)new DERObjectIdentifier("1.2.398.3.10.1.3.1.1.0"));
        this.id = GostCertID.createCertID(hashAlg, issuerCert, new DERInteger(number));
    }

    public CertID toASN1Object() {
        return this.id;
    }

    public int hashCode() {
        return this.id.getDERObject().hashCode();
    }

    private static CertID createCertID(AlgorithmIdentifier hashAlg, X509Certificate issuerCert, DERInteger serialNumber) throws OCSPException {
        try {
            String hashAlgorithm = hashAlg.getObjectId().getId();
            DEROctetString issuerNameHash = GostCertID.generateIssuerNameHash(hashAlgorithm, issuerCert);
            DEROctetString issuerKeyHash = GostCertID.generateIssuerKeyHash(hashAlgorithm, issuerCert);
            return new CertID(hashAlg, (ASN1OctetString)issuerNameHash, (ASN1OctetString)issuerKeyHash, serialNumber);
        }
        catch (Exception var6) {
            throw new OCSPException("problem creating ID: " + var6, var6);
        }
    }

    private static DEROctetString generateIssuerNameHash(String hashAlg, X509Certificate certificate) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(hashAlg, "KALKAN");
        X509Principal issuerName = PrincipalUtil.getSubjectX509Principal((X509Certificate)certificate);
        byte[] digestEncoded = digest.digest(issuerName.getEncoded());
        return new DEROctetString(digestEncoded);
    }

    private static DEROctetString generateIssuerKeyHash(String hashAlg, X509Certificate certificate) throws Exception {
        DEROctetString var8;
        MessageDigest digest = MessageDigest.getInstance(hashAlg, "KALKAN");
        PublicKey issuerKey = certificate.getPublicKey();
        try (ASN1InputStream aIn = new ASN1InputStream(issuerKey.getEncoded());){
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)aIn.readObject());
            byte[] bytes = GostCertID.extractValueFromAsn1Object(info.getPublicKeyData().getBytes());
            var8 = new DEROctetString(digest.digest(bytes));
        }
        return var8;
    }

    private static byte[] extractValueFromAsn1Object(byte[] asn1Object) throws Exception {
        if (asn1Object.length < 2) {
            throw new Exception("Array not have valid size!");
        }
        byte[] newBuffer = new byte[asn1Object.length - 2];
        System.arraycopy(asn1Object, 2, newBuffer, 0, asn1Object.length - 2);
        return newBuffer;
    }
}

