/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.PCSCCode;
import kz.gov.pki.kalkan.util.io.Streams;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.reference.KeyStoreEntry;

public class KeyStoreUtil {
    private static List<X509Certificate> caCertificates;

    public static KeyStore getKeyStore(Storage storage, String container, char[] password, Provider provider) throws KeyStoreException, NoSuchProviderException, ProviderUtilException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store = KeyStore.getInstance(storage.getName(), provider.getName());
        try {
            KeyStoreUtil.loadKeyStore(storage, container, store, password);
            return store;
        }
        catch (IOException var11) {
            String msg = "WRONG_PASSWORD";
            if (var11.getMessage().contains("password")) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD, -1, msg, (Throwable)var11);
            }
            if (var11.getCause() instanceof KalkanException) {
                KalkanException ke = (KalkanException)var11.getCause();
                if (ke.getErrorCode().equals(PCSCCode.WRONG_PIN) || ke.getErrorCode().equals(PCSCCode.INVALID_PIN_VALUE)) {
                    Object o;
                    Object sw = ke.get("SW");
                    if (sw != null) {
                        msg = msg + " \u041a\u043e\u0434: " + sw;
                    }
                    if ((o = ke.get("RetryCount")) != null) {
                        Integer retryCount = (Integer)ke.get("RetryCount");
                        throw new ProviderUtilException(ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD, retryCount.intValue(), msg, (Throwable)ke);
                    }
                    throw new ProviderUtilException(ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD, -1, msg, (Throwable)ke);
                }
                if (ke.getErrorCode().equals(PCSCCode.BLOCKED_PIN)) {
                    throw new ProviderUtilException(ProviderUtilExceptionCode.BLOCKED_KEYSTORE_PASSWORD, "\u041f\u0430\u0440\u043e\u043b\u044c \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d.", (Throwable)ke);
                }
            }
            throw var11;
        }
    }

    @Deprecated
    public static Map<String, KeyStoreEntry> getKeyStoreEntries(Storage storage, String container, char[] password, Provider provider) throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, ProviderUtilException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStoreUtil.getKeyStore(storage, container, password, provider);
        HashMap<String, KeyStoreEntry> result = new HashMap<String, KeyStoreEntry>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            if (cert != null) {
                result.put(alias, new KeyStoreEntry(alias, cert.getPublicKey().getAlgorithm(), cert));
                continue;
            }
            result.put(alias, new KeyStoreEntry(alias, keyStore.getKey(alias, password).getAlgorithm(), (X509Certificate)null));
        }
        return result;
    }

    public static void setCaCerts(List<X509Certificate> certificates) {
        caCertificates = certificates;
    }

    public static List<X509Certificate> getCaCerts() {
        return caCertificates != null ? caCertificates : kz.gov.pki.provider.utils.KeyStoreUtil.getDefaultCACerts();
    }

    private static void loadKeyStore(Storage storage, String container, KeyStore keyStore, char[] password) throws NoSuchAlgorithmException, IOException, CertificateException {
        InputStream inputStream;
        if (storage.isToken()) {
            inputStream = Streams.fromString((String)container);
        } else {
            if (container == null) {
                keyStore.load(null);
                return;
            }
            inputStream = new FileInputStream(container);
        }
        try {
            keyStore.load(inputStream, password);
        }
        catch (Exception var6) {
            inputStream.close();
        }
    }
}

