/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.ocsp.OCSPObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.X509Extension;
import kz.gov.pki.kalkan.asn1.x509.X509Extensions;
import kz.gov.pki.kalkan.ocsp.BasicOCSPResp;
import kz.gov.pki.kalkan.ocsp.CertificateID;
import kz.gov.pki.kalkan.ocsp.CertificateStatus;
import kz.gov.pki.kalkan.ocsp.OCSPException;
import kz.gov.pki.kalkan.ocsp.OCSPReq;
import kz.gov.pki.kalkan.ocsp.OCSPReqGenerator;
import kz.gov.pki.kalkan.ocsp.OCSPResp;
import kz.gov.pki.kalkan.ocsp.RevokedStatus;
import kz.gov.pki.kalkan.ocsp.SingleResp;
import kz.gov.pki.kalkan.ocsp.UnknownStatus;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.metadoc.ncamodule.core.ProviderManager;
import kz.metadoc.ncamodule.core.exceptions.OcspException;
import kz.metadoc.ncamodule.core.exceptions.UnknownOcspAddressException;
import kz.metadoc.ncamodule.core.exceptions.verification.CertificateStatusException;
import kz.metadoc.ncamodule.core.log.LoggingPoint;
import kz.metadoc.ncamodule.core.utils.CertificateUtil;
import kz.metadoc.ncamodule.core.utils.GostCertID;

public final class OCSPUtil {
    private final X509Certificate certificate;
    private final X509Certificate issuerCertificate;
    private final String serverUrl;
    private byte[] randomSecuredNumber;

    public OCSPUtil(X509Certificate certificate) throws Exception {
        this.issuerCertificate = CertificateUtil.getIssuerCertificate(certificate);
        this.serverUrl = CertificateUtil.getUrlToOcsp(certificate);
        this.certificate = certificate;
    }

    public OCSPUtil(X509Certificate certificate, X509Certificate issuerCertificate, String ocspUrl) {
        this.issuerCertificate = issuerCertificate;
        this.serverUrl = ocspUrl;
        this.certificate = certificate;
    }

    public OCSPResp getOCSPResponse() throws OcspException {
        OCSPReq ocspReq = this.createOCSPReq();
        return this.sendRequest(ocspReq);
    }

    public byte[] getBinaryOCSPResponse() throws OcspException, IOException {
        OCSPReq ocspReq = this.createOCSPReq();
        OCSPResp response = this.sendRequest(ocspReq);
        return response.getEncoded();
    }

    public static CertificateStatus getCertificateStatusFromResponse(OCSPResp response) throws OCSPException {
        BasicOCSPResp basicOCSPResp = (BasicOCSPResp)response.getResponseObject();
        SingleResp[] singleResponse = basicOCSPResp.getResponses();
        SingleResp singleResp = singleResponse[0];
        return (CertificateStatus)singleResp.getCertStatus();
    }

    public static X509Certificate getCertificateFromResponse(OCSPResp response) throws OCSPException {
        BasicOCSPResp basicOCSPResp = (BasicOCSPResp)response.getResponseObject();
        try {
            return basicOCSPResp.getCerts(ProviderManager.getProviderName())[0];
        }
        catch (Exception var3) {
            throw new OCSPException(var3.getMessage());
        }
    }

    public static void validateCertificateAndResponseLink(X509Certificate certificate, X509Certificate issuerCertificate, OCSPResp response) throws OCSPException {
        BasicOCSPResp basicOCSPResp = (BasicOCSPResp)response.getResponseObject();
        try {
            CertificateID certIdFromResponse = basicOCSPResp.getResponses()[0].getCertID();
            boolean success = certIdFromResponse.getSerialNumber().equals(certificate.getSerialNumber());
            if (!success) {
                throw new OCSPException("OCSP response is not for current certificate!");
            }
        }
        catch (OCSPException var6) {
            throw var6;
        }
        catch (Exception var7) {
            throw new OCSPException(var7.getMessage());
        }
    }

    public static Date getProducedDate(OCSPResp response) throws OCSPException {
        BasicOCSPResp basicOCSPResp = (BasicOCSPResp)response.getResponseObject();
        return new Date(basicOCSPResp.getProducedAt().getTime());
    }

    public static void validateResponseDate(OCSPResp response, Date checkDate) throws OCSPException {
        long oneMinute;
        BasicOCSPResp basicOCSPResp = (BasicOCSPResp)response.getResponseObject();
        long checkDateTime = checkDate.getTime();
        long factDateTime = basicOCSPResp.getProducedAt().getTime();
        long timeDiff = Math.abs(factDateTime - checkDateTime);
        if (timeDiff > (oneMinute = 60000L) * 5L) {
            throw new OCSPException("OCSP response expired!");
        }
    }

    public static void validateStatus(OCSPResp response) throws OCSPException, CertificateStatusException {
        CertificateStatus status = OCSPUtil.getCertificateStatusFromResponse(response);
        if (status != CertificateStatus.GOOD) {
            if (status instanceof RevokedStatus) {
                throw new CertificateStatusException(1);
            }
            if (status instanceof UnknownStatus) {
                throw new CertificateStatusException(2);
            }
        }
    }

    private static CertificateID createCertificateID(X509Certificate certificate, X509Certificate issuerCertificate) throws OCSPException {
        String issuerDN = issuerCertificate.getIssuerDN().toString();
        if (issuerDN.contains("GOST")) {
            return new CertificateID(CertificateID.HASH_GOST34311, issuerCertificate, certificate.getSerialNumber(), "KALKAN");
        }
        if (issuerDN.contains("RSA")) {
            return new CertificateID(CertificateID.HASH_GOST34311GT, issuerCertificate, certificate.getSerialNumber(), "KALKAN");
        }
        GostCertID newCertID = new GostCertID(issuerCertificate, certificate.getSerialNumber());
        return new CertificateID(newCertID.toASN1Object());
    }

    private static CertificateID createCertificateID(X509Certificate certificate, X509Certificate issuerCertificate, String hashAlgorithmOID) throws OCSPException {
        return new CertificateID(hashAlgorithmOID, issuerCertificate, certificate.getSerialNumber(), "KALKAN");
    }

    private X509Extensions generateNonce() {
        SecureRandom sr = new SecureRandom();
        this.randomSecuredNumber = new byte[16];
        sr.nextBytes(this.randomSecuredNumber);
        Hashtable<DERObjectIdentifier, X509Extension> extensions = new Hashtable<DERObjectIdentifier, X509Extension>();
        X509Extension nonceExtension = new X509Extension(false, (ASN1OctetString)new DEROctetString((DEREncodable)new DEROctetString(this.randomSecuredNumber)));
        extensions.put(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, nonceExtension);
        return new X509Extensions(extensions);
    }

    private OCSPReq createOCSPReq() throws OcspException {
        try {
            CertificateID certificateID = OCSPUtil.createCertificateID(this.certificate, this.issuerCertificate);
            OCSPReqGenerator gen = new OCSPReqGenerator();
            gen.addRequest(certificateID);
            gen.setRequestExtensions(this.generateNonce());
            return gen.generate();
        }
        catch (Exception var3) {
            throw new OcspException("UNKNOWN_CAUSE", var3);
        }
    }

    private OCSPResp sendRequest(OCSPReq request) throws OcspException {
        OCSPResp var4;
        LoggingPoint.log("Start send OCSP request");
        try {
            OCSPResp response;
            byte[] encoded = request.getEncoded();
            try {
                response = encoded.length < 256 ? this.sendGetRequest(encoded) : this.sendPostRequest(encoded);
            }
            catch (UnknownHostException var10) {
                throw new UnknownOcspAddressException(this.serverUrl);
            }
            this.validationResponse(response);
            var4 = response;
        }
        catch (OcspException var11) {
            throw var11;
        }
        catch (Exception var12) {
            throw new OcspException("UNKNOWN_CAUSE", var12);
        }
        finally {
            LoggingPoint.log("Finish sent OCSP request");
        }
        return var4;
    }

    private OCSPResp sendGetRequest(byte[] encoded) throws IOException {
        String path = Base64.encodeStr((byte[])encoded);
        URL url = new URL(this.serverUrl + "/" + path);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        con.setRequestProperty("Pragma", "no-cache");
        con.setRequestProperty("Expires", "0");
        con.setUseCaches(false);
        InputStream in = con.getInputStream();
        OCSPResp response = new OCSPResp(in);
        in.close();
        con.disconnect();
        return response;
    }

    private OCSPResp sendPostRequest(byte[] encoded) throws IOException {
        URL url = new URL(this.serverUrl);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/ocsp-request");
        con.setRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        con.setRequestProperty("Pragma", "no-cache");
        con.setRequestProperty("Expires", "0");
        con.setUseCaches(false);
        OutputStream os = con.getOutputStream();
        os.write(encoded);
        os.close();
        InputStream in = con.getInputStream();
        OCSPResp response = new OCSPResp(in);
        in.close();
        con.disconnect();
        return response;
    }

    private boolean verifySecuredNumber(BasicOCSPResp response) throws IOException {
        byte[] respNonceExt = response.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nonce.getId());
        if (respNonceExt == null) {
            return true;
        }
        ASN1InputStream asn1In = new ASN1InputStream(respNonceExt);
        DERObject derObj = asn1In.readObject();
        asn1In.close();
        byte[] extV = DEROctetString.getInstance((Object)derObj).getOctets();
        asn1In = new ASN1InputStream(extV);
        derObj = asn1In.readObject();
        asn1In.close();
        return Arrays.equals(this.randomSecuredNumber, DEROctetString.getInstance((Object)derObj).getOctets());
    }

    private void validationResponse(OCSPResp response) throws OCSPException, IOException, SecurityException {
        if (response.getStatus() != 0) {
            throw new OCSPException("Unsuccessful request! Status: " + response.getStatus());
        }
        BasicOCSPResp basicOCSPResp = (BasicOCSPResp)response.getResponseObject();
        if (!this.verifySecuredNumber(basicOCSPResp)) {
            throw new SecurityException("Receive fake response!");
        }
    }
}

