/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Date;
import kz.gov.pki.kalkan.asn1.cms.Attribute;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.tsp.TSPAlgorithms;
import kz.gov.pki.kalkan.tsp.TSPException;
import kz.gov.pki.kalkan.tsp.TimeStampRequest;
import kz.gov.pki.kalkan.tsp.TimeStampRequestGenerator;
import kz.gov.pki.kalkan.tsp.TimeStampResponse;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.gov.pki.kalkan.util.io.Streams;
import kz.metadoc.ncamodule.core.SignedAttributeIdentifiers;
import kz.metadoc.ncamodule.core.exceptions.UnknownTspAddressException;
import kz.metadoc.ncamodule.core.exceptions.verification.TimeStampValidationException;

public class TimeStampUtil {
    private static boolean checkNonce = false;
    private static String address;
    private final byte[] data;
    private final BigInteger nonce;

    public TimeStampUtil(byte[] data, BigInteger nonce) {
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        if (checkNonce && nonce == null) {
            throw new IllegalArgumentException("nonce");
        }
        this.data = data;
        this.nonce = nonce;
    }

    public static void disableCheckNonce() {
        checkNonce = false;
    }

    public static void enableCheckNonce() {
        checkNonce = true;
    }

    public static void setTimeStampServerAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException("Address could not be NULL!");
        }
        TimeStampUtil.address = address;
    }

    public static Date getSignDateFromAttributeTable(AttributeTable unsignedAttributes) {
        try {
            Attribute tspResponseAttribute = unsignedAttributes.get(SignedAttributeIdentifiers.TSP_RESPONSE);
            if (tspResponseAttribute == null) {
                throw new RuntimeException("Could not find tsp attribute!");
            }
            byte[] rawTSPResponse = tspResponseAttribute.getAttrValues().getObjectAt(0).getDERObject().getEncoded();
            TimeStampResponse tspResponse = new TimeStampResponse(rawTSPResponse);
            return tspResponse.getTimeStampToken().getTimeStampInfo().getGenTime();
        }
        catch (Exception var4) {
            throw new RuntimeException("TSP response no have time!");
        }
    }

    public static Date getDateFromTimeStamp(TimeStampResponse tspResponse) {
        return tspResponse.getTimeStampToken().getTimeStampInfo().getGenTime();
    }

    public static void validateTimeStamp(TimeStampResponse tspResponse, byte[] signedData) throws TimeStampValidationException {
        if (checkNonce) {
            try {
                BigInteger nonce = tspResponse.getTimeStampToken().getTimeStampInfo().getNonce();
                TimeStampUtil tsu = new TimeStampUtil(signedData, nonce);
                tspResponse.validate(tsu.buildRequest());
            }
            catch (Exception var4) {
                throw new TimeStampValidationException(var4);
            }
        }
    }

    public TimeStampRequest buildRequest(X509Certificate certificate) throws NoSuchAlgorithmException {
        String digestAlgorithm = "SHA1";
        String digestAlgorithmOID = TSPAlgorithms.SHA1;
        if (certificate.getSigAlgName().equals("ECGOST34310") || certificate.getSigAlgName().equals("1.2.398.3.10.1.1.1.2") || certificate.getSigAlgName().equals("1.3.6.1.4.1.6801.1.2.2")) {
            digestAlgorithm = "GOST3411";
            digestAlgorithmOID = TSPAlgorithms.GOST34311;
        }
        TimeStampRequestGenerator tsRequestGenerator = new TimeStampRequestGenerator();
        MessageDigest digest = MessageDigest.getInstance(digestAlgorithm);
        digest.reset();
        byte[] digestData = digest.digest(this.data);
        tsRequestGenerator.setCertReq(true);
        tsRequestGenerator.setReqPolicy(KNCAObjectIdentifiers.tsa_gost_policy.getId());
        return tsRequestGenerator.generate(digestAlgorithmOID, digestData, this.nonce);
    }

    public TimeStampRequest buildRequest() throws NoSuchAlgorithmException {
        TimeStampRequestGenerator tsRequestGenerator = new TimeStampRequestGenerator();
        MessageDigest digest = MessageDigest.getInstance("SHA1");
        byte[] digestData = digest.digest(this.data);
        return tsRequestGenerator.generate(TSPAlgorithms.SHA1, digestData, this.nonce);
    }

    public TimeStampResponse sendRequest() throws IOException, TSPException, NoSuchAlgorithmException, UnknownTspAddressException {
        return this.sendRequest(this.buildRequest());
    }

    public TimeStampResponse sendRequest(TimeStampRequest request) throws IOException, TSPException, UnknownTspAddressException {
        byte[] encodedRequest;
        return this.sendRequest(encodedRequest, (encodedRequest = request.getEncoded()).length > 255);
    }

    private TimeStampResponse sendRequest(byte[] encoded, boolean isPost) throws IOException, TSPException, UnknownTspAddressException {
        try {
            TimeStampResponse resp;
            String addressWithPath;
            String path = Base64.encodeStr((byte[])encoded);
            if (isPost) {
                addressWithPath = address;
            } else {
                String startAddress = address.endsWith("/") ? address : address + "/";
                addressWithPath = startAddress + path;
            }
            URL url = new URL(addressWithPath);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            if (isPost) {
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-Type", "application/ocsp-request");
                con.setRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
                con.setRequestProperty("Pragma", "no-cache");
                con.setRequestProperty("Expires", "0");
                con.setUseCaches(false);
                con.setDoOutput(true);
                OutputStream os = con.getOutputStream();
                os.write(encoded);
                os.close();
            } else {
                con.setRequestMethod("GET");
                con.setRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
                con.setRequestProperty("Pragma", "no-cache");
                con.setRequestProperty("Expires", "0");
                con.setUseCaches(false);
            }
            try (InputStream inputStream = con.getInputStream();){
                byte[] response = Streams.readAll((InputStream)inputStream);
                resp = new TimeStampResponse(response);
            }
            con.disconnect();
            return resp;
        }
        catch (UnknownHostException var21) {
            throw new UnknownTspAddressException(address);
        }
    }
}

