/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.pcsc.TokenDispatcher;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;

public class TokenLoader {
    public static String loadSlotList(String storageName) throws Exception {
        String sl = null;
        try {
            TokenLoader.establishNewContext();
        }
        catch (Exception var8) {
            System.out.println(var8.getMessage());
        }
        TerminalFactory factory = TerminalFactory.getDefault();
        List<CardTerminal> lReaders = factory.terminals().list();
        Iterator<CardTerminal> var4 = lReaders.iterator();
        while (var4.hasNext()) {
            CardTerminal terminalObject;
            CardTerminal terminal = terminalObject = var4.next();
            String tName = terminal.getName();
            System.out.println(tName + " = isPresent = " + terminal.isCardPresent());
            if (!terminal.isCardPresent()) continue;
            if (storageName.equals(Storage.KAZTOKEN.getName())) {
                if (!TokenLoader.isSpecifiedToken(tName, Storage.KAZTOKEN.getName())) continue;
                sl = sl == null ? tName : sl + "<:>" + tName;
                continue;
            }
            if (storageName.equals(Storage.KZIDCARD.getName())) {
                if (tName.startsWith("DigiFlow LLP. KAZTOKEN") || !TokenLoader.isSpecifiedToken(tName, Storage.KZIDCARD.getName()) || TokenLoader.getPublicPartInfo(tName) == null) continue;
                sl = sl == null ? tName : sl + "<:>" + tName;
                continue;
            }
            if (storageName.equals(Storage.ETOKEN_72K.getName())) {
                if (tName.startsWith("DigiFlow LLP. KAZTOKEN") || !TokenLoader.isSpecifiedToken(tName, Storage.ETOKEN_72K.getName())) continue;
                sl = sl == null ? tName : sl + "<:>" + tName;
                continue;
            }
            if (storageName.equals(Storage.JACARTA.getName())) {
                if (tName.startsWith("DigiFlow LLP. KAZTOKEN") || !TokenLoader.isSpecifiedToken(tName, Storage.JACARTA.getName())) continue;
                sl = sl == null ? tName : sl + "<:>" + tName;
                continue;
            }
            if (storageName.equals(Storage.AKEY.getName())) {
                if (tName.startsWith("DigiFlow LLP. KAZTOKEN") || !TokenLoader.isSpecifiedToken(tName, Storage.AKEY.getName())) continue;
                sl = sl == null ? tName : sl + "<:>" + tName;
                continue;
            }
            System.err.println("Smartcard type is unknown!");
            sl = "UNKNOWN_SMARTCARD";
        }
        return sl;
    }

    private static String getPublicPartInfo(String terminalName) {
        try {
            AKToken token = TokenDispatcher.INSTANCE.instantiateToken(Storage.KAZTOKEN.getName(), terminalName, (String)null);
            TokenDispatcher.INSTANCE.removeToken(token);
            return "IIN" + token.getPublicPartInfo("IIN") + " " + token.getPublicPartInfo("FULLNAME");
        }
        catch (Exception var2) {
            return null;
        }
    }

    private static boolean isSpecifiedToken(String tName, String type) {
        try {
            AKToken at = TokenDispatcher.INSTANCE.instantiateToken(type, tName, (String)null);
            TokenDispatcher.INSTANCE.removeToken(at);
            return true;
        }
        catch (KalkanException var3) {
            return false;
        }
    }

    private static void establishNewContext() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.contains("windows")) {
            Class<?> pcscterminal = Class.forName("sun.security.smartcardio.PCSCTerminals");
            Field contextId = pcscterminal.getDeclaredField("contextId");
            contextId.setAccessible(true);
            if (contextId.getLong(pcscterminal) != 0L) {
                Class<?> pcsc = Class.forName("sun.security.smartcardio.PCSC");
                Method SCardEstablishContext = pcsc.getDeclaredMethod("SCardEstablishContext", Integer.TYPE);
                SCardEstablishContext.setAccessible(true);
                Field SCARD_SCOPE_USER = pcsc.getDeclaredField("SCARD_SCOPE_USER");
                SCARD_SCOPE_USER.setAccessible(true);
                long newId = (Long)SCardEstablishContext.invoke(pcsc, SCARD_SCOPE_USER.getInt(pcsc));
                contextId.setLong(pcscterminal, newId);
                TerminalFactory factory = TerminalFactory.getDefault();
                CardTerminals terminals = factory.terminals();
                Field fieldTerminals = pcscterminal.getDeclaredField("terminals");
                fieldTerminals.setAccessible(true);
                Class<?> classMap = Class.forName("java.util.Map");
                Method clearMap = classMap.getDeclaredMethod("clear", new Class[0]);
                clearMap.invoke(fieldTerminals.get(terminals), new Object[0]);
                Field fieldStateMap = pcscterminal.getDeclaredField("stateMap");
                fieldStateMap.setAccessible(true);
                clearMap.invoke(fieldStateMap.get(terminals), new Object[0]);
            }
        }
    }
}

