/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.utils.xmls;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kz.metadoc.ncamodule.core.exceptions.SignatureDamagedException;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlsdsigUtil {
    private static final String SIGN_TAG = "sign";
    private static final String SIGNATURE_NODE_NAME = "Signature";

    public static String getSignatureFromXml(Document xml) {
        NodeList list = xml.getElementsByTagName(SIGN_TAG);
        int signsCount = list.getLength();
        if (signsCount == 0) {
            throw new RuntimeException("Not found sign in xml!");
        }
        if (signsCount > 1) {
            throw new RuntimeException("Found more than one sign in xml!");
        }
        return list.item(0).getTextContent();
    }

    public static Document createDomDocumentFromString(String xml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            return documentBuilder.parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception var3) {
            throw new RuntimeException(var3);
        }
    }

    public static List<XMLSignature> getXmlDSignatures(Document document) throws SignatureDamagedException {
        try {
            NodeList list = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_NODE_NAME);
            int length = list.getLength();
            ArrayList<XMLSignature> nodes = new ArrayList<XMLSignature>();
            for (int i = 0; i < length; ++i) {
                XMLSignature element = new XMLSignature((Element)list.item(i), "");
                nodes.add(element);
            }
            return nodes;
        }
        catch (Exception var6) {
            throw new SignatureDamagedException("Could not load signature from xml", var6);
        }
    }

    public static X509Certificate getCertificateFromXmlSignature(String xml) throws SignatureDamagedException {
        try {
            Document document = XmlsdsigUtil.createDomDocumentFromString(xml);
            List<XMLSignature> signatures = XmlsdsigUtil.getXmlDSignatures(document);
            return signatures.get(0).getKeyInfo().getX509Certificate();
        }
        catch (Exception var3) {
            throw new SignatureDamagedException("Could not parse certificate form xml", var3);
        }
    }
}

