/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.verificators;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformation;
import kz.gov.pki.kalkan.ocsp.OCSPResp;
import kz.gov.pki.kalkan.tsp.TimeStampResponse;
import kz.metadoc.ncamodule.core.SignedAttributeIdentifiers;
import kz.metadoc.ncamodule.core.exceptions.CRLVerificationException;
import kz.metadoc.ncamodule.core.exceptions.SignatureDamagedException;
import kz.metadoc.ncamodule.core.exceptions.UnknownCaException;
import kz.metadoc.ncamodule.core.exceptions.certificates.DefectCertificateException;
import kz.metadoc.ncamodule.core.exceptions.certificates.IssuerCertificateNotFoundException;
import kz.metadoc.ncamodule.core.exceptions.verification.CertificatePermissionException;
import kz.metadoc.ncamodule.core.exceptions.verification.CertificateStatusException;
import kz.metadoc.ncamodule.core.exceptions.verification.CmsNotContainsOcspException;
import kz.metadoc.ncamodule.core.exceptions.verification.CmsNotContainsTspException;
import kz.metadoc.ncamodule.core.exceptions.verification.MessageDigestVerificationException;
import kz.metadoc.ncamodule.core.exceptions.verification.TimeStampValidationException;
import kz.metadoc.ncamodule.core.utils.AttributeUtil;
import kz.metadoc.ncamodule.core.utils.CertificateChainUtil;
import kz.metadoc.ncamodule.core.utils.CertificateUtil;
import kz.metadoc.ncamodule.core.utils.CmsUtil;
import kz.metadoc.ncamodule.core.utils.OCSPUtil;
import kz.metadoc.ncamodule.core.utils.TimeStampUtil;
import kz.metadoc.ncamodule.core.verificators.CmsSignVerification;

public class DefaultSignVerification
extends CmsSignVerification {
    public void verify(byte[] signature, byte[] signedData) throws SignatureDamagedException, MessageDigestVerificationException, CertificatePermissionException, CmsNotContainsTspException, TimeStampValidationException, DefectCertificateException, CertificateStatusException, CRLVerificationException, CertificateNotYetValidException, UnknownCaException, CertificateExpiredException, CmsNotContainsOcspException {
        CMSSignedData cms = CmsUtil.updateDataInCMS(signature, signedData);
        Map<SignerInformation, X509Certificate> signersMap = CmsUtil.getCertificatesFromSignature(cms);
        for (SignerInformation signerInfo : signersMap.keySet()) {
            this.verifySingleSigner(signerInfo, signersMap.get(signerInfo), signedData);
        }
    }

    private void verifySingleSigner(SignerInformation signerInfo, X509Certificate certificate, byte[] signedData) throws CmsNotContainsTspException, MessageDigestVerificationException, CertificateNotYetValidException, CertificateExpiredException, CmsNotContainsOcspException, CertificateStatusException, CertificatePermissionException, DefectCertificateException, CRLVerificationException, UnknownCaException, TimeStampValidationException, SignatureDamagedException {
        this.verifyMessageDigest(signerInfo, certificate);
        TimeStampResponse response = this.getTspFromSignerInfo(signerInfo);
        Date signTime = TimeStampUtil.getDateFromTimeStamp(response);
        CertificateUtil.validateCertificateExpire(certificate, signTime);
        this.verifyOcsp(certificate, signerInfo, signTime);
        this.checkCertificatePermissions(certificate);
        CertificateChainUtil.validateCertificateChain(certificate, signTime);
        TimeStampUtil.validateTimeStamp(response, signedData);
    }

    private void verifyOcsp(X509Certificate certificate, SignerInformation signerInfo, Date signTime) throws CmsNotContainsOcspException, CertificateStatusException, SignatureDamagedException, UnknownCaException {
        OCSPResp ocspResponse;
        try {
            ocspResponse = this.getOcspFromSignerInfo(signerInfo);
            OCSPUtil.validateStatus(ocspResponse);
            OCSPUtil.validateCertificateAndResponseLink(certificate, CertificateUtil.getIssuerCertificate(certificate), ocspResponse);
            OCSPUtil.validateResponseDate(ocspResponse, signTime);
        }
        catch (IssuerCertificateNotFoundException var7) {
            throw new UnknownCaException(var7);
        }
        catch (CertificateStatusException | CmsNotContainsOcspException var8) {
            throw var8;
        }
        catch (Exception var9) {
            throw new SignatureDamagedException("OCSP_HAS_BROKEN", var9);
        }
        try {
            X509Certificate ocspCertificate = OCSPUtil.getCertificateFromResponse(ocspResponse);
            CertificateUtil.getIssuerCertificate(ocspCertificate);
        }
        catch (Exception var6) {
            throw new UnknownCaException(var6);
        }
    }

    private TimeStampResponse getTspFromSignerInfo(SignerInformation signerInfo) throws CmsNotContainsTspException {
        DERObject TspResponseObject = AttributeUtil.getAttributeObject(signerInfo.getUnsignedAttributes(), SignedAttributeIdentifiers.TSP_RESPONSE);
        if (TspResponseObject == null) {
            throw new CmsNotContainsTspException();
        }
        try {
            return new TimeStampResponse(TspResponseObject.getEncoded());
        }
        catch (Exception var4) {
            throw new RuntimeException(var4);
        }
    }

    private OCSPResp getOcspFromSignerInfo(SignerInformation signerInfo) throws CmsNotContainsOcspException {
        try {
            DEROctetString ocspResponseString = (DEROctetString)AttributeUtil.getAttributeObject(signerInfo.getSignedAttributes(), SignedAttributeIdentifiers.OCSP_RESPONSE);
            if (ocspResponseString == null) {
                throw new CmsNotContainsOcspException();
            }
            return new OCSPResp(ocspResponseString.getOctets());
        }
        catch (CmsNotContainsOcspException var3) {
            throw var3;
        }
        catch (Exception var4) {
            throw new RuntimeException(var4);
        }
    }
}

