/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.verificators;

import java.security.Signature;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedDataGenerator;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.metadoc.ncamodule.core.exceptions.CRLVerificationException;
import kz.metadoc.ncamodule.core.exceptions.UnknownCaException;
import kz.metadoc.ncamodule.core.exceptions.certificates.DefectCertificateException;
import kz.metadoc.ncamodule.core.exceptions.verification.CertificatePermissionException;
import kz.metadoc.ncamodule.core.exceptions.verification.CertificateStatusException;
import kz.metadoc.ncamodule.core.exceptions.verification.MessageDigestVerificationException;
import kz.metadoc.ncamodule.core.utils.CertificateChainUtil;
import kz.metadoc.ncamodule.core.utils.CertificateConverter;
import kz.metadoc.ncamodule.core.utils.CertificateUtil;
import kz.metadoc.ncamodule.core.verificators.SignVerification;

public class RawSignatureVerification
extends SignVerification {
    private final String certificateAsBase64;
    private final String sign;
    private final String signedData;
    private final Date signTime;

    public RawSignatureVerification(String certificate, String sign, String signedData, Date signTime) {
        this.certificateAsBase64 = certificate;
        this.sign = sign;
        this.signedData = signedData;
        this.signTime = signTime;
    }

    public void verify() throws MessageDigestVerificationException, DefectCertificateException, CertificateStatusException, UnknownCaException, CRLVerificationException, CertificatePermissionException, CertificateNotYetValidException, CertificateExpiredException {
        X509Certificate certificate = CertificateConverter.fromBase64ToCertificate(this.certificateAsBase64);
        this.checkMessageDigest(certificate);
        CertificateUtil.validateCertificateExpire(certificate, this.signTime);
        this.checkCertificatePermissions(certificate);
        CertificateChainUtil.validateCertificateChain(certificate, this.signTime);
    }

    private void checkMessageDigest(X509Certificate certificate) throws MessageDigestVerificationException {
        try {
            String digestName = RawSignatureVerification.extractSignAlgorithm(certificate);
            String signatureName = digestName + "with" + certificate.getSigAlgOID();
            Signature sig = Signature.getInstance(signatureName, "KALKAN");
            sig.initVerify(certificate.getPublicKey());
            sig.update(Base64.decode((String)this.signedData));
            if (!sig.verify(Base64.decode((String)this.sign))) {
                throw new Exception("NOT_VALID");
            }
        }
        catch (Exception var5) {
            throw new MessageDigestVerificationException(var5);
        }
    }

    private static String extractSignAlgorithm(X509Certificate certificate) {
        String algorithm = certificate.getSigAlgOID().equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId()) ? CMSSignedDataGenerator.DIGEST_SHA1 : (certificate.getSigAlgOID().equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId()) ? CMSSignedDataGenerator.DIGEST_SHA256 : (certificate.getSigAlgOID().equals(KNCAObjectIdentifiers.gost34311_95_with_gost34310_2004.getId()) ? CMSSignedDataGenerator.DIGEST_GOST34311_95 : (certificate.getSigAlgOID().equals(KNCAObjectIdentifiers.gost3411_2015_with_gost3410_2015_512.getId()) ? CMSSignedDataGenerator.DIGEST_GOST3411_2015_512 : CMSSignedDataGenerator.DIGEST_GOST3411_GT)));
        return algorithm;
    }
}

