/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.verificators;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.Consumer;
import kz.metadoc.ncamodule.core.exceptions.verification.CertificateForAuthenticationException;
import kz.metadoc.ncamodule.core.exceptions.verification.CertificateNoHavePermissionsForSignException;
import kz.metadoc.ncamodule.core.exceptions.verification.CertificatePermissionException;
import kz.metadoc.ncamodule.core.utils.CertificatePermission;
import kz.metadoc.ncamodule.core.utils.CertificatePermissionUtil;
import kz.metadoc.ncamodule.core.utils.CertificatePolicy;
import kz.metadoc.ncamodule.core.utils.CertificateUtil;

abstract class SignVerification {
    private Consumer<X509Certificate> action = null;
    private List<CertificatePermission> permissions = null;
    private List<CertificatePolicy> allowedPolicies = null;

    SignVerification() {
    }

    public void setCheckCertificatePermissionHandler(Consumer<X509Certificate> action) {
        this.action = action;
    }

    public void setPermissionsForCheck(List<CertificatePermission> permissions) {
        this.permissions = permissions;
    }

    public void setAllowedCertificatePolicies(List<CertificatePolicy> policies) {
        this.allowedPolicies = policies;
    }

    protected void checkCertificatePermissions(X509Certificate certificate) throws CertificatePermissionException {
        if (this.action != null) {
            this.action.accept(certificate);
        } else {
            this.checkPolicies(certificate);
            this.checkPermissions(certificate);
        }
    }

    private void checkPolicies(X509Certificate certificate) throws CertificatePermissionException {
        if (this.allowedPolicies == null) {
            if (!CertificatePermissionUtil.isKeyForSign(certificate)) {
                throw new CertificateForAuthenticationException();
            }
        } else {
            CertificatePermissionUtil.checkPolicies(certificate, this.allowedPolicies.toArray(new CertificatePolicy[0]));
        }
    }

    private void checkPermissions(X509Certificate certificate) throws CertificatePermissionException {
        if (!CertificateUtil.checkCertficateIssuer(certificate, "C=KZ,O=TTC,CN=PKI") && !CertificateUtil.checkCertficateIssuer(certificate, "CN=\u0423\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u044f\u044e\u0449\u0438\u0439 \u0446\u0435\u043d\u0442\u0440 \u0413\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u043e\u0440\u0433\u0430\u043d\u043e\u0432,O=\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d,C=KZ")) {
            if (this.permissions == null) {
                if (!CertificatePermissionUtil.isHavePermissionsForSign(certificate)) {
                    throw new CertificateNoHavePermissionsForSignException();
                }
            } else {
                try {
                    CertificatePermissionUtil.checkExtensionPermissions(certificate, this.permissions.toArray(new CertificatePermission[0]));
                }
                catch (Exception var3) {
                    throw new CertificateNoHavePermissionsForSignException();
                }
            }
        }
    }
}

