/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.core.verificators.xml;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import kz.metadoc.ncamodule.core.exceptions.KeyLoadException;
import kz.metadoc.ncamodule.core.exceptions.SignatureDamagedException;
import kz.metadoc.ncamodule.core.exceptions.verification.MessageDigestVerificationException;
import kz.metadoc.ncamodule.core.utils.xmls.XmlsdsigUtil;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Document;

public class DefaultSignVerification {
    public void verify(String xml) throws SignatureDamagedException, MessageDigestVerificationException, KeyLoadException {
        Document document = XmlsdsigUtil.createDomDocumentFromString(xml);
        List<XMLSignature> signatures = XmlsdsigUtil.getXmlDSignatures(document);
        for (XMLSignature xmlSignature : signatures) {
            this.verifySignature(xmlSignature);
        }
    }

    private void verifySignature(XMLSignature signature) throws MessageDigestVerificationException, KeyLoadException {
        try {
            boolean failVerify;
            KeyInfo keyInfo = signature.getKeyInfo();
            PublicKey publicKey = this.getPublicKeyFromKeyInfo(keyInfo);
            boolean bl = failVerify = !signature.checkSignatureValue((Key)publicKey);
            if (failVerify) {
                throw new MessageDigestVerificationException((Exception)null);
            }
        }
        catch (XMLSignatureException var5) {
            throw new MessageDigestVerificationException((Exception)((Object)var5));
        }
    }

    private PublicKey getPublicKeyFromKeyInfo(KeyInfo keyInfo) throws KeyLoadException {
        try {
            X509Certificate certificate = keyInfo.getX509Certificate();
            return certificate != null ? certificate.getPublicKey() : keyInfo.getPublicKey();
        }
        catch (Exception var3) {
            throw new KeyLoadException("Could not load public key from xml", var3);
        }
    }
}

