/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.knca;

import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public enum BundleLog {
    LOG;

    public static BundleContext context;
    private LogService logService;

    public void discoverLogService() throws InvalidSyntaxException {
        String logServiceFilter = "(objectClass=" + LogService.class.getName() + ")";
        ServiceTracker logService_tracker = new ServiceTracker(context, context.createFilter(logServiceFilter), (ServiceTrackerCustomizer)null);
        logService_tracker.open();
        this.logService = (LogService)logService_tracker.getService();
        if (this.logService == null) {
            context.addServiceListener(e -> {
                if (e.getType() == 1) {
                    this.logService = (LogService)logService_tracker.getService(e.getServiceReference());
                    this.info("Found LogService while listening");
                }
            }, logServiceFilter);
        } else {
            this.info("Found LogService on load");
        }
    }

    public void info(String msg) {
        if (this.logService != null) {
            this.log(3, msg);
        } else {
            System.out.println(msg);
        }
    }

    public void debug(String msg) {
        if (this.logService != null) {
            this.log(4, msg);
        } else {
            System.out.println(msg);
        }
    }

    public void error(String msg, Throwable e) {
        if (this.logService != null) {
            this.log(1, msg, e);
        } else {
            System.err.println(msg);
            e.printStackTrace();
        }
    }

    public void log(int level, String msg) {
        if (this.logService != null) {
            this.logService.log(level, msg);
        } else {
            System.out.println(msg);
        }
    }

    public void log(int level, String msg, Throwable e) {
        if (this.logService != null) {
            this.logService.log(level, msg, e);
        } else {
            System.err.println(msg);
            e.printStackTrace();
        }
    }
}

