/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.knca;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.function.Function;
import javax.swing.JFrame;
import javax.swing.UIManager;
import kz.metadoc.ncamodule.knca.BundleLog;
import kz.metadoc.ncamodule.knca.gui.ProgramSettings;
import kz.metadoc.ncamodule.knca.gui.dialog.SignerDialog;
import kz.metadoc.ncamodule.knca.gui.fileChooser.FileChooserDialog;
import kz.metadoc.ncamodule.knca.types.ClientException;
import kz.metadoc.ncamodule.knca.types.KeyInfo;
import kz.metadoc.ncamodule.knca.types.ResponseMessage;
import kz.metadoc.ncamodule.knca.types.StorageInfo;
import org.json.JSONObject;

public class CommonUtils {
    private Function keyInfoService;
    private Function keyInfoSetterService;
    DateFormat df = new SimpleDateFormat("dd.MM.yyyy (HH:mm)");

    public void setKeyInfoServices(Function keyInfoService) {
        this.keyInfoService = keyInfoService;
    }

    public void setKeyInfoSetterService(Function keyInfoSetterService) {
        this.keyInfoSetterService = keyInfoSetterService;
    }

    public CommonUtils() {
        String osname = System.getProperty("os.name").toLowerCase();
        this.df.setTimeZone(TimeZone.getTimeZone("Asia/Almaty"));
        try {
            if (osname.contains("mac os")) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getKeyInfo(String storageName) {
        ResponseMessage<KeyInfo> res = new ResponseMessage<KeyInfo>("500");
        try {
            StorageInfo storageInfo = new StorageInfo(storageName, this.keyInfoService, this.keyInfoSetterService);
            HashMap<String, String> titles = new HashMap<String, String>();
            titles.put("title", "label.signerDialog.keyInfoTitle");
            titles.put("actionBtn", "button.signerDialog.keyInfo");
            titles.put("header", "label.signerDialog.infoTitle");
            SignerDialog signerDialog = new SignerDialog(storageInfo, null, titles);
            signerDialog.setVisible(true);
            if (signerDialog.getDoSign()) {
                SignerDialog.KeyListEntry keyStoreEntry = signerDialog.getSelectedItem();
                res.setCode("200");
                res.setResponseObject(new KeyInfo(keyStoreEntry, storageInfo));
                if (!storageInfo.isNewkey()) return this.getJson(res);
            }
            res.setMessage("action.canceled");
            return this.getJson(res);
        }
        catch (Exception e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
            res.setMessage(e.getMessage());
        }
        return this.getJson(res);
    }

    public String getFilePath() {
        return this.showFileChooser("P12", null);
    }

    public String showFileChooser(String fileExtension, String currentDirectory) {
        ResponseMessage<String> responseMessage = new ResponseMessage<String>("500");
        try {
            responseMessage.setResponseObject(this.chooseFile(fileExtension, currentDirectory));
            responseMessage.setCode("200");
        }
        catch (Exception e) {
            responseMessage.setMessage(e.getMessage());
        }
        return this.getJson(responseMessage);
    }

    public String changeLocale(String language) {
        ResponseMessage responseMessage = new ResponseMessage("200");
        ProgramSettings.getInstance().changeLocale(language);
        return this.getJson(responseMessage);
    }

    private String getBase64FromFile(String file_path) throws ClientException {
        try {
            Path path = Paths.get(file_path, new String[0]);
            byte[] fileBytes = Files.readAllBytes(path);
            return Base64.getEncoder().encodeToString(fileBytes);
        }
        catch (IOException e) {
            throw new ClientException("file.not_found");
        }
    }

    private String chooseFile(String fileExt, String currentDirectory) throws ClientException {
        FileChooserDialog fileChooserDialog = new FileChooserDialog(new JFrame(), fileExt, currentDirectory);
        if (fileChooserDialog.getSelectedFilePath() != null) {
            return fileChooserDialog.getSelectedFilePath();
        }
        throw new ClientException("action.canceled");
    }

    private String getJson(Object o) {
        return JSONObject.wrap((Object)o).toString();
    }
}

