/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.knca;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.reference.KeyStoreEntry;
import kz.metadoc.ncamodule.core.exceptions.KeyLoadException;
import kz.metadoc.ncamodule.core.exceptions.WrongPasswordException;
import kz.metadoc.ncamodule.core.keys.FileKeyLoader;
import kz.metadoc.ncamodule.knca.types.KeyInfo;

public class KeyInfoUtil {
    public static KeyInfo getKeyInfo(String filePath, String password) throws IOException, ProviderUtilException, NoSuchProviderException, KeyLoadException, WrongPasswordException, CertificateException {
        byte[] file = Files.readAllBytes(Paths.get(filePath, new String[0]));
        FileKeyLoader fileKeyLoader = new FileKeyLoader(file, password);
        X509Certificate certificate = fileKeyLoader.getCertificate();
        String keyId = X509Util.getKeyId((X509Certificate)certificate);
        String algorithm = certificate.getPublicKey().getAlgorithm();
        String alias = fileKeyLoader.getAlias();
        KeyInfo keyInfo = new KeyInfo(new KeyStoreEntry(keyId, algorithm, certificate));
        keyInfo.setAlias(alias);
        keyInfo.setPath(filePath);
        return keyInfo;
    }
}

