/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.knca;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.function.Function;
import kz.gov.pki.osgi.layer.api.ModuleService;
import kz.metadoc.ncamodule.knca.BundleLog;
import kz.metadoc.ncamodule.knca.BundleProvider;
import kz.metadoc.ncamodule.knca.CommonUtils;
import kz.metadoc.ncamodule.knca.types.ResponseMessage;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class NCALayerCommonActivator
implements BundleActivator {
    private static final int[] ARRAY_INT = new int[0];
    private static final String[] ARRAY_STRING = new String[0];

    public void start(BundleContext context) throws Exception {
        try {
            BundleLog.LOG.discoverLogService();
            BundleProvider.KALKAN.discoverProviderService();
            CommonUtils commonUtils = new CommonUtils();
            this.getKeyInfoService(context, commonUtils);
            this.getKeyInfoSetterService(context, commonUtils);
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("module", "kz.metadoc.ncamodule.knca.commonUtils");
            context.registerService(ModuleService.class.getName().toString(), (Object)this.getModuleService(commonUtils), props);
        }
        catch (Exception e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
            throw new Exception("Can not start bundle NCALayerCommon!");
        }
    }

    private void getKeyInfoService(BundleContext context, CommonUtils commonUtils) throws Exception {
        String serviceFilter = "(&(objectClass=" + Function.class.getName() + ")(module=kz.gov.pki.ncalayerservices.getKeyInfo))";
        ServiceTracker module_tracker = new ServiceTracker(context, context.createFilter(serviceFilter), (ServiceTrackerCustomizer)null);
        module_tracker.open();
        Function ncalayerservices_accessory = (Function)module_tracker.getService();
        if (ncalayerservices_accessory == null) {
            context.addServiceListener(e -> {
                if (e.getType() == 1) {
                    commonUtils.setKeyInfoServices((Function)module_tracker.getService(e.getServiceReference()));
                }
            }, serviceFilter);
        } else {
            commonUtils.setKeyInfoServices(ncalayerservices_accessory);
        }
    }

    private void getKeyInfoSetterService(BundleContext context, CommonUtils commonUtils) throws Exception {
        String serviceFilter = "(&(objectClass=" + Function.class.getName() + ")(module=kz.gov.pki.ncalayerservices.setKeyInfo))";
        ServiceTracker module_tracker = new ServiceTracker(context, context.createFilter(serviceFilter), (ServiceTrackerCustomizer)null);
        module_tracker.open();
        Function ncalayerservices_accessory = (Function)module_tracker.getService();
        if (ncalayerservices_accessory == null) {
            context.addServiceListener(e -> {
                if (e.getType() == 1) {
                    commonUtils.setKeyInfoSetterService((Function)module_tracker.getService(e.getServiceReference()));
                }
            }, serviceFilter);
        } else {
            commonUtils.setKeyInfoSetterService(ncalayerservices_accessory);
        }
    }

    public void stop(BundleContext context) throws Exception {
    }

    private ModuleService getModuleService(CommonUtils commonUtils) {
        return (jsonString, headers) -> {
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                String uuid = jsonObject.optString("uuid");
                String mname = jsonObject.getString("method");
                JSONArray args = jsonObject.optJSONArray("args");
                int argLen = args != null ? args.length() : 0;
                Method method = null;
                if (!mname.isEmpty()) {
                    Method[] declaredMethods;
                    Method[] ms = declaredMethods = commonUtils.getClass().getDeclaredMethods();
                    for (Method m : declaredMethods) {
                        if (!m.getName().equals(mname) || m.getParameterTypes().length != argLen) continue;
                        method = m;
                        break;
                    }
                }
                if (method == null) {
                    return this.getErrorResponse("NoSuchMethodException " + mname);
                }
                Object[] argObjs = null;
                if (argLen > 0) {
                    argObjs = new Object[argLen];
                }
                for (int i = 0; i < argLen; ++i) {
                    Object objArg = args.get(i);
                    if (objArg instanceof JSONArray) {
                        int j;
                        JSONArray arrayObj = (JSONArray)objArg;
                        if (method.getParameterTypes()[i].isInstance(ARRAY_INT)) {
                            int[] arrayArg = new int[arrayObj.length()];
                            for (j = 0; j < arrayArg.length; ++j) {
                                arrayArg[j] = arrayObj.getInt(j);
                            }
                            argObjs[i] = arrayArg;
                            continue;
                        }
                        if (method.getParameterTypes()[i].isInstance(ARRAY_STRING)) {
                            String[] arrayArg2 = new String[arrayObj.length()];
                            for (j = 0; j < arrayArg2.length; ++j) {
                                arrayArg2[j] = arrayObj.getString(j);
                            }
                            argObjs[i] = arrayArg2;
                            continue;
                        }
                        Object[] arrayArg3 = new Object[arrayObj.length()];
                        for (j = 0; j < arrayArg3.length; ++j) {
                            arrayArg3[j] = arrayObj.get(j);
                        }
                        argObjs[i] = arrayArg3;
                        continue;
                    }
                    argObjs[i] = objArg;
                }
                String jsonResult = null;
                try {
                    jsonResult = (String)method.invoke((Object)commonUtils, argObjs);
                }
                catch (Exception e) {
                    BundleLog.LOG.log(1, e.getMessage(), e);
                    return this.getErrorResponse(e + ". Method: " + mname);
                }
                if (uuid.isEmpty()) {
                    return jsonResult;
                }
                JSONObject resultObject = new JSONObject(jsonResult);
                return resultObject.put("uuid", (Object)uuid).toString();
            }
            catch (Exception e2) {
                BundleLog.LOG.log(1, e2.getMessage(), e2);
                return this.getErrorResponse(e2.getMessage());
            }
        };
    }

    private String getErrorResponse(String msg) {
        ResponseMessage responseForJS = new ResponseMessage("500");
        responseForJS.setMessage(msg);
        return ((JSONObject)JSONObject.wrap(responseForJS)).toString();
    }
}

