/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.knca.types;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import kz.gov.pki.kalkan.util.encoders.Hex;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.reference.KNCACertificateType;
import kz.gov.pki.reference.KeyStoreEntry;
import kz.metadoc.ncamodule.knca.BundleLog;
import kz.metadoc.ncamodule.knca.types.StorageInfo;

public class KeyInfo {
    private String alias;
    private String path;
    private String keyId;
    private String algorithm;
    private String subjectCn;
    private String subjectDn;
    private String issuerCn;
    private String issuerDn;
    private String serialNumber;
    private String certNotAfter;
    private String certNotBefore;
    private String authorityKeyIdentifier;
    private String pem;
    private String usage;

    public KeyInfo(KeyStoreEntry keyStoreEntry) {
        X509Certificate certificate = keyStoreEntry.getX509Certificate();
        this.subjectCn = keyStoreEntry.getSubjectCn();
        this.algorithm = keyStoreEntry.getAlgorithm();
        this.issuerCn = keyStoreEntry.getIssuerCn();
        this.serialNumber = keyStoreEntry.getSerialNumber();
        this.certNotAfter = String.valueOf(certificate.getNotAfter().getTime());
        this.certNotBefore = String.valueOf(certificate.getNotBefore().getTime());
        this.subjectDn = X509Util.getSubjectDN((X509Certificate)certificate).toString();
        this.issuerDn = X509Util.getIssuerDN((X509Certificate)certificate).toString();
        try {
            this.keyId = X509Util.getKeyId((X509Certificate)certificate);
            this.authorityKeyIdentifier = Hex.encodeStr((byte[])X509Util.getAuthorityKeyIdentifier((X509Extension)certificate));
            this.usage = X509Util.getKNCACertificateType((X509Certificate)certificate).contains(KNCACertificateType.AUTHENTICATION) ? "auth" : "sign";
        }
        catch (Exception e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
        }
        try {
            this.pem = X509Util.getPem((X509Certificate)keyStoreEntry.getX509Certificate());
        }
        catch (IOException e2) {
            BundleLog.LOG.log(1, e2.getMessage(), e2);
        }
    }

    public KeyInfo(KeyStoreEntry keyStoreEntry, StorageInfo storageInfo) {
        String alias = storageInfo.getAlias();
        X509Certificate certificate = keyStoreEntry.getX509Certificate();
        this.alias = alias;
        this.path = storageInfo.getContainer();
        this.subjectCn = keyStoreEntry.getSubjectCn();
        this.algorithm = keyStoreEntry.getAlgorithm();
        this.issuerCn = keyStoreEntry.getIssuerCn();
        this.serialNumber = keyStoreEntry.getSerialNumber();
        this.certNotAfter = String.valueOf(certificate.getNotAfter().getTime());
        this.certNotBefore = String.valueOf(certificate.getNotBefore().getTime());
        this.subjectDn = X509Util.getSubjectDN((X509Certificate)certificate).toString();
        this.issuerDn = X509Util.getIssuerDN((X509Certificate)certificate).toString();
        try {
            this.keyId = X509Util.getKeyId((X509Certificate)certificate);
            this.authorityKeyIdentifier = Hex.encodeStr((byte[])X509Util.getAuthorityKeyIdentifier((X509Extension)certificate));
            this.usage = X509Util.getKNCACertificateType((X509Certificate)certificate).contains(KNCACertificateType.AUTHENTICATION) ? "auth" : "sign";
        }
        catch (Exception e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
        }
        try {
            this.pem = X509Util.getPem((X509Certificate)keyStoreEntry.getX509Certificate());
        }
        catch (IOException e2) {
            BundleLog.LOG.log(1, e2.getMessage(), e2);
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public String getPath() {
        return this.path;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getSubjectCn() {
        return this.subjectCn;
    }

    public String getSubjectDn() {
        return this.subjectDn;
    }

    public String getIssuerCn() {
        return this.issuerCn;
    }

    public String getIssuerDn() {
        return this.issuerDn;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getCertNotAfter() {
        return this.certNotAfter;
    }

    public String getCertNotBefore() {
        return this.certNotBefore;
    }

    public String getAuthorityKeyIdentifier() {
        return this.authorityKeyIdentifier;
    }

    public String getPem() {
        return this.pem;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setSubjectCn(String subjectCn) {
        this.subjectCn = subjectCn;
    }

    public void setSubjectDn(String subjectDn) {
        this.subjectDn = subjectDn;
    }

    public void setIssuerCn(String issuerCn) {
        this.issuerCn = issuerCn;
    }

    public void setIssuerDn(String issuerDn) {
        this.issuerDn = issuerDn;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setCertNotAfter(String certNotAfter) {
        this.certNotAfter = certNotAfter;
    }

    public void setCertNotBefore(String certNotBefore) {
        this.certNotBefore = certNotBefore;
    }

    public void setAuthorityKeyIdentifier(String authorityKeyIdentifier) {
        this.authorityKeyIdentifier = authorityKeyIdentifier;
    }

    public void setPem(String pem) {
        this.pem = pem;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyInfo)) {
            return false;
        }
        KeyInfo other = (KeyInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (!(this$alias == null ? other$alias == null : this$alias.equals(other$alias))) {
            return false;
        }
        String this$keyId = this.getKeyId();
        String other$keyId = other.getKeyId();
        if (!(this$keyId == null ? other$keyId == null : this$keyId.equals(other$keyId))) {
            return false;
        }
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (!(this$algorithm == null ? other$algorithm == null : this$algorithm.equals(other$algorithm))) {
            return false;
        }
        String this$subjectCn = this.getSubjectCn();
        String other$subjectCn = other.getSubjectCn();
        if (!(this$subjectCn == null ? other$subjectCn == null : this$subjectCn.equals(other$subjectCn))) {
            return false;
        }
        String this$subjectDn = this.getSubjectDn();
        String other$subjectDn = other.getSubjectDn();
        if (!(this$subjectDn == null ? other$subjectDn == null : this$subjectDn.equals(other$subjectDn))) {
            return false;
        }
        String this$issuerCn = this.getIssuerCn();
        String other$issuerCn = other.getIssuerCn();
        if (!(this$issuerCn == null ? other$issuerCn == null : this$issuerCn.equals(other$issuerCn))) {
            return false;
        }
        String this$issuerDn = this.getIssuerDn();
        String other$issuerDn = other.getIssuerDn();
        if (!(this$issuerDn == null ? other$issuerDn == null : this$issuerDn.equals(other$issuerDn))) {
            return false;
        }
        String this$serialNumber = this.getSerialNumber();
        String other$serialNumber = other.getSerialNumber();
        if (!(this$serialNumber == null ? other$serialNumber == null : this$serialNumber.equals(other$serialNumber))) {
            return false;
        }
        String this$certNotAfter = this.getCertNotAfter();
        String other$certNotAfter = other.getCertNotAfter();
        if (!(this$certNotAfter == null ? other$certNotAfter == null : this$certNotAfter.equals(other$certNotAfter))) {
            return false;
        }
        String this$certNotBefore = this.getCertNotBefore();
        String other$certNotBefore = other.getCertNotBefore();
        if (!(this$certNotBefore == null ? other$certNotBefore == null : this$certNotBefore.equals(other$certNotBefore))) {
            return false;
        }
        String this$authorityKeyIdentifier = this.getAuthorityKeyIdentifier();
        String other$authorityKeyIdentifier = other.getAuthorityKeyIdentifier();
        if (!(this$authorityKeyIdentifier == null ? other$authorityKeyIdentifier == null : this$authorityKeyIdentifier.equals(other$authorityKeyIdentifier))) {
            return false;
        }
        String this$pem = this.getPem();
        String other$pem = other.getPem();
        return this$pem == null ? other$pem == null : this$pem.equals(other$pem);
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : $keyId.hashCode());
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        String $subjectCn = this.getSubjectCn();
        result = result * 59 + ($subjectCn == null ? 43 : $subjectCn.hashCode());
        String $subjectDn = this.getSubjectDn();
        result = result * 59 + ($subjectDn == null ? 43 : $subjectDn.hashCode());
        String $issuerCn = this.getIssuerCn();
        result = result * 59 + ($issuerCn == null ? 43 : $issuerCn.hashCode());
        String $issuerDn = this.getIssuerDn();
        result = result * 59 + ($issuerDn == null ? 43 : $issuerDn.hashCode());
        String $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        String $certNotAfter = this.getCertNotAfter();
        result = result * 59 + ($certNotAfter == null ? 43 : $certNotAfter.hashCode());
        String $certNotBefore = this.getCertNotBefore();
        result = result * 59 + ($certNotBefore == null ? 43 : $certNotBefore.hashCode());
        String $authorityKeyIdentifier = this.getAuthorityKeyIdentifier();
        result = result * 59 + ($authorityKeyIdentifier == null ? 43 : $authorityKeyIdentifier.hashCode());
        String $pem = this.getPem();
        result = result * 59 + ($pem == null ? 43 : $pem.hashCode());
        return result;
    }

    public String toString() {
        return "KeyInfo(alias=" + this.getAlias() + ", keyId=" + this.getKeyId() + ", algorithm=" + this.getAlgorithm() + ", subjectCn=" + this.getSubjectCn() + ", subjectDn=" + this.getSubjectDn() + ", issuerCn=" + this.getIssuerCn() + ", issuerDn=" + this.getIssuerDn() + ", serialNumber=" + this.getSerialNumber() + ", certNotAfter=" + this.getCertNotAfter() + ", certNotBefore=" + this.getCertNotBefore() + ", authorityKeyIdentifier=" + this.getAuthorityKeyIdentifier() + ", pem=" + this.getPem() + ")";
    }
}

