/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.osgi;

import java.util.Hashtable;
import java.util.function.Function;
import kz.gov.pki.osgi.layer.api.ModuleService;
import kz.gov.pki.osgi.layer.api.NCALayerService;
import kz.metadoc.ncamodule.core.ProviderManager;
import kz.metadoc.ncamodule.core.log.LoggingPoint;
import kz.metadoc.ncamodule.core.utils.TimeStampUtil;
import kz.metadoc.ncamodule.knca.BundleLog;
import kz.metadoc.ncamodule.knca.BundleProvider;
import kz.metadoc.ncamodule.knca.CommonUtils;
import kz.metadoc.ncamodule.osgi.services.SignModuleService;
import kz.metadoc.ncamodule.osgi.swing.SwingGuiService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class MetadocBundleActivator
implements BundleActivator {
    LogService logService = null;
    NCALayerService ncaLayerService = null;

    public void start(BundleContext context) throws Exception {
        BundleLog.context = context;
        BundleLog.LOG.discoverLogService();
        BundleProvider.context = context;
        BundleProvider.KALKAN.discoverProviderService();
        CommonUtils commonUtils = new CommonUtils();
        this.getKeyInfoService(context, commonUtils);
        this.getKeyInfoSetterService(context, commonUtils);
        SignModuleService moduleService = new SignModuleService();
        moduleService.setCommonUtils(commonUtils);
        moduleService.setModuleVersion(context.getBundle().getVersion());
        this.getLogService(context, moduleService);
        this.getNCALayerService(context, moduleService);
        this.registerService(context, moduleService);
        TimeStampUtil.setTimeStampServerAddress("http://tsp.pki.gov.kz/");
        this.setGuiService(moduleService);
    }

    public void stop(BundleContext context) throws Exception {
    }

    private void registerService(BundleContext context, SignModuleService moduleService) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("module", "kz.metadoc.NCAModule");
        context.registerService(ModuleService.class.getName(), (Object)moduleService, props);
    }

    private void getLogService(BundleContext context, SignModuleService moduleService) throws InvalidSyntaxException {
        String logServiceFilter = "(objectClass=" + LogService.class.getName() + ")";
        ServiceTracker logServiceTracker = new ServiceTracker(context, context.createFilter(logServiceFilter), null);
        logServiceTracker.open();
        this.logService = (LogService)logServiceTracker.getService();
        if (this.logService == null) {
            context.addServiceListener(e -> {
                if (e.getType() == 1) {
                    this.logService = (LogService)logServiceTracker.getService(e.getServiceReference());
                    if (this.logService != null) {
                        LoggingPoint.setLogAction(x -> this.logService.log(4, x));
                    }
                    moduleService.setLogService(this.logService);
                }
            }, logServiceFilter);
        } else {
            moduleService.setLogService(this.logService);
            LoggingPoint.setLogAction(x -> this.logService.log(4, x));
        }
    }

    private void getNCALayerService(BundleContext context, SignModuleService moduleService) throws InvalidSyntaxException {
        String filter = "(objectClass=" + NCALayerService.class.getName() + ")";
        ServiceTracker ncaLayerService_tracker = new ServiceTracker(context, context.createFilter(filter), (ServiceTrackerCustomizer)null);
        ncaLayerService_tracker.open();
        this.ncaLayerService = (NCALayerService)ncaLayerService_tracker.getService();
        if (this.ncaLayerService == null) {
            context.addServiceListener(e -> {
                if (e.getType() == 1) {
                    this.ncaLayerService = (NCALayerService)ncaLayerService_tracker.getService(e.getServiceReference());
                    ProviderManager.setProvider(this.ncaLayerService.getProvider());
                }
            }, filter);
        } else {
            ProviderManager.setProvider(this.ncaLayerService.getProvider());
        }
    }

    private void getKeyInfoService(BundleContext context, CommonUtils commonUtils) throws Exception {
        String serviceFilter = "(&(objectClass=" + Function.class.getName() + ")(module=kz.gov.pki.ncalayerservices.getKeyInfo))";
        ServiceTracker module_tracker = new ServiceTracker(context, context.createFilter(serviceFilter), (ServiceTrackerCustomizer)null);
        module_tracker.open();
        Function ncalayerservices_accessory = (Function)module_tracker.getService();
        if (ncalayerservices_accessory == null) {
            context.addServiceListener(e -> {
                if (e.getType() == 1) {
                    commonUtils.setKeyInfoServices((Function)module_tracker.getService(e.getServiceReference()));
                }
            }, serviceFilter);
        } else {
            commonUtils.setKeyInfoServices(ncalayerservices_accessory);
        }
    }

    private void getKeyInfoSetterService(BundleContext context, CommonUtils commonUtils) throws Exception {
        String serviceFilter = "(&(objectClass=" + Function.class.getName() + ")(module=kz.gov.pki.ncalayerservices.setKeyInfo))";
        ServiceTracker module_tracker = new ServiceTracker(context, context.createFilter(serviceFilter), (ServiceTrackerCustomizer)null);
        module_tracker.open();
        Function ncalayerservices_accessory = (Function)module_tracker.getService();
        if (ncalayerservices_accessory == null) {
            context.addServiceListener(e -> {
                if (e.getType() == 1) {
                    commonUtils.setKeyInfoSetterService((Function)module_tracker.getService(e.getServiceReference()));
                }
            }, serviceFilter);
        } else {
            commonUtils.setKeyInfoSetterService(ncalayerservices_accessory);
        }
    }

    private void setGuiService(SignModuleService moduleService) {
        moduleService.setGuiService(new SwingGuiService());
    }
}

