/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.osgi.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kz.gov.pki.osgi.layer.api.ModuleService;
import kz.gov.pki.provider.utils.XMLUtil;
import kz.gov.pki.provider.utils.model.SigningEntity;
import kz.metadoc.ncamodule.core.ProviderManager;
import kz.metadoc.ncamodule.core.exceptions.CRLVerificationException;
import kz.metadoc.ncamodule.core.exceptions.DownloadCertificateException;
import kz.metadoc.ncamodule.core.exceptions.KeyLoadException;
import kz.metadoc.ncamodule.core.exceptions.UnknownCaException;
import kz.metadoc.ncamodule.core.exceptions.UnknownOcspAddressException;
import kz.metadoc.ncamodule.core.exceptions.UnknownTspAddressException;
import kz.metadoc.ncamodule.core.exceptions.WrongPasswordException;
import kz.metadoc.ncamodule.core.exceptions.certificates.IssuerCertificateNotFoundException;
import kz.metadoc.ncamodule.core.exceptions.verification.CertificateForAuthenticationException;
import kz.metadoc.ncamodule.core.exceptions.verification.CertificateNoHavePermissionsForSignException;
import kz.metadoc.ncamodule.core.exceptions.verification.CertificatePermissionException;
import kz.metadoc.ncamodule.core.exceptions.verification.CertificateStatusException;
import kz.metadoc.ncamodule.core.exceptions.verification.TimeStampValidationException;
import kz.metadoc.ncamodule.core.generators.DefaultSignatureGenerator;
import kz.metadoc.ncamodule.core.keys.FileKeyLoader;
import kz.metadoc.ncamodule.core.keys.KeyLoader;
import kz.metadoc.ncamodule.core.keys.TokenKeyLoader;
import kz.metadoc.ncamodule.core.utils.CertificatePolicy;
import kz.metadoc.ncamodule.core.verificators.DefaultSignVerification;
import kz.metadoc.ncamodule.knca.CommonUtils;
import kz.metadoc.ncamodule.knca.KeyInfoUtil;
import kz.metadoc.ncamodule.knca.types.KeyInfo;
import kz.metadoc.ncamodule.osgi.exceptions.AbortException;
import kz.metadoc.ncamodule.osgi.responses.Response;
import kz.metadoc.ncamodule.osgi.services.GuiService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.Version;
import org.osgi.service.log.LogService;

public class SignModuleService
implements ModuleService {
    private LogService logService;
    private GuiService guiService;
    private Version version;
    private CommonUtils commonUtils;

    public String process(String jsonString, String headers) {
        this.logService.log(3, "Start process");
        JSONObject requestJSON = new JSONObject(jsonString);
        String method = requestJSON.getString("method");
        JSONArray args = requestJSON.optJSONArray("args");
        this.logService.log(3, "Method: " + method);
        if ("getKeyInfo".equals(method)) {
            String storageName = args.getString(0);
            return this.commonUtils.getKeyInfo(storageName);
        }
        if ("getModuleVersion".equals(method)) {
            return this.getModuleVersion();
        }
        if ("signXml".equals(method)) {
            return this.signXml(requestJSON);
        }
        if ("getKeyInfoByFilePathAndPassword".equals(method)) {
            return this.getKeyInfoByFilePathAndPassword(requestJSON);
        }
        if ("getFilePath".equals(method)) {
            return this.commonUtils.getFilePath();
        }
        return this.sign(requestJSON);
    }

    private String getKeyInfoByFilePathAndPassword(JSONObject request) {
        Response<KeyInfo> response = new Response<KeyInfo>("500");
        String filePath = request.getString("filePath");
        String password = request.getString("password");
        try {
            KeyInfo keyInfo = KeyInfoUtil.getKeyInfo(filePath, password);
            response.setCode("200");
            response.setResponseObject(keyInfo);
        }
        catch (Exception e) {
            this.logService.log(1, e.getMessage());
            this.processError(e, response);
        }
        return JSONObject.wrap(response).toString();
    }

    private String sign(JSONObject requestJSON) {
        Response<String> response = new Response<String>("500");
        try {
            KeyLoader keyLoader = this.createKeyLoader(requestJSON);
            String filesNames = this.validateStringArgument(requestJSON, "filesNames");
            byte[] dataForSign = this.validateBase64Argument(requestJSON, "dataForSign");
            boolean skipCheckPermissions = requestJSON.has("skipCheckPermissions") && requestJSON.getBoolean("skipCheckPermissions");
            List<String> policies = this.validateArrayArgument(requestJSON, "policies", true);
            String sign = this.makeSignature(keyLoader, filesNames, dataForSign);
            this.logService.log(3, "Success signing.");
            Thread.sleep(200L);
            try {
                this.verifySignature(sign, dataForSign, skipCheckPermissions, policies);
            }
            catch (Exception var12) {
                this.logService.log(1, sign);
                throw var12;
            }
            response.setCode("200");
            response.setResponseObject(sign);
        }
        catch (Exception var13) {
            this.processError(var13, response);
        }
        return JSONObject.wrap(response).toString();
    }

    private void processError(Exception e, Response response) {
        this.logService.log(1, "Could not process.", (Throwable)e);
        if (e instanceof AbortException) {
            response.setMessage("action.cancelled");
        } else if (e instanceof FileNotFoundException || e instanceof NoSuchFileException) {
            response.setMessage("FILE_NOT_FOUND");
        } else if (e instanceof CertificateStatusException) {
            if (e.getMessage().equals("Certificate revoked!")) {
                response.setMessage("CERTIFICATE_REVOKED");
            }
            if (e.getMessage().equals("Certificate unknown!")) {
                response.setMessage("CERTIFICATE_UNKNOWN");
            }
        } else if (e instanceof WrongPasswordException) {
            response.setMessage("WRONG_PASSWORD");
        } else if (e instanceof CertificateExpiredException) {
            response.setMessage("CERTIFICATE_EXPIRED");
        } else if (e instanceof CertificateNotYetValidException) {
            response.setMessage("CERTIFICATE_NOT_YET_VALID");
        } else if (e instanceof CertificateForAuthenticationException) {
            response.setMessage("CERTIFICATE_FOR_AUTHENTICATION");
        } else if (e instanceof CertificateNoHavePermissionsForSignException) {
            response.setMessage("CERTIFICATE_NO_HAVE_PERM_FOR_SIGN");
        } else if (e instanceof UnknownTspAddressException) {
            response.setMessage("UNKNOWN_TSP_ADDRESS");
            response.addParam("address", ((UnknownTspAddressException)e).getTspAddress());
        } else if (e instanceof UnknownOcspAddressException) {
            response.setMessage("UNKNOWN_OCSP_ADDRESS");
            response.addParam("address", ((UnknownOcspAddressException)e).getOcspAddress());
        } else if (!(e instanceof UnknownCaException) && !(e instanceof IssuerCertificateNotFoundException)) {
            if (e instanceof DownloadCertificateException) {
                response.setMessage("DOWNLOAD_CERTIFICATE_EXCEPTION");
                response.addParam("address", ((DownloadCertificateException)e).getCertificateAddress());
            } else if (e instanceof TimeStampValidationException) {
                response.setMessage("TSP_NOT_VALID");
            } else if (e instanceof CRLVerificationException) {
                response.setMessage("CRL_VERIFICATION_FAILED");
            } else if (e.getCause() != null && e.getCause() instanceof UnknownTspAddressException) {
                response.setMessage("UNKNOWN_TSP_ADDRESS");
                response.addParam("address", ((UnknownTspAddressException)e.getCause()).getTspAddress());
            } else if (e instanceof CertificatePermissionException) {
                response.setMessage("CERTIFICATE_NO_HAVE_PERM");
            } else {
                response.setMessage(e.getMessage());
            }
        } else {
            response.setMessage("UNKNOWN_CA");
        }
    }

    private void verifySignature(String sign, byte[] dataForSign, boolean skipCheckPermissions, List<String> policies) throws Exception {
        DefaultSignVerification signVerification = new DefaultSignVerification();
        if (skipCheckPermissions) {
            signVerification.setPermissionsForCheck((List)new ArrayList());
        }
        if (policies != null) {
            signVerification.setAllowedCertificatePolicies((List)this.convertStringsToPolicies(policies));
        }
        signVerification.verify(Base64.getDecoder().decode(sign), dataForSign);
    }

    private List<CertificatePolicy> convertStringsToPolicies(List<String> policies) {
        return policies.stream().map(CertificatePolicy::valueOf).collect(Collectors.toList());
    }

    private String makeSignature(KeyLoader keyLoader, String filesNames, byte[] dataForSign) throws Exception {
        DefaultSignatureGenerator generator = new DefaultSignatureGenerator(filesNames);
        return generator.sign(keyLoader, dataForSign);
    }

    private byte[] validateBase64Argument(JSONObject requestJSON, String fieldName) throws Exception {
        String fieldAsString = requestJSON.getString(fieldName);
        if (fieldAsString != null && fieldAsString.length() != 0) {
            try {
                return Base64.getDecoder().decode(fieldAsString);
            }
            catch (Exception var5) {
                throw new Exception("\"" + fieldName + "\" argument should use BASE64 format!");
            }
        }
        throw new Exception("\"" + fieldName + "\" argument could not be empty or NULL!");
    }

    private String validateStringArgument(JSONObject requestJSON, String fieldName) throws Exception {
        String field = requestJSON.getString(fieldName);
        if (field != null && field.length() != 0) {
            return field;
        }
        throw new Exception("\"" + fieldName + "\" argument could not be empty or NULL!");
    }

    private List<String> validateArrayArgument(JSONObject requestJSON, String fieldName, boolean allowNulalbel) {
        if (!requestJSON.has(fieldName)) {
            return allowNulalbel ? null : new ArrayList();
        }
        ArrayList<String> elements = new ArrayList<String>();
        JSONArray array = requestJSON.getJSONArray(fieldName);
        for (int i = 0; i < array.length(); ++i) {
            elements.add(array.getString(i));
        }
        return elements;
    }

    private KeyLoader createKeyLoader(JSONObject request) throws IOException, NoSuchProviderException, KeyLoadException, WrongPasswordException, AbortException {
        String keyType = request.getString("keyType");
        String password = null;
        if (request.has("password")) {
            password = request.getString("password");
        }
        if (password == null || password.trim().isEmpty()) {
            password = this.guiService.openSignDataDialog();
        }
        if (password == null) {
            throw new AbortException();
        }
        if (keyType.equals("file")) {
            String tokenName = request.getString("filePath");
            byte[] file = Files.readAllBytes(Paths.get(tokenName, new String[0]));
            return new FileKeyLoader(file, password);
        }
        if (keyType.equals("token")) {
            String tokenName = request.getString("tokenName");
            return new TokenKeyLoader(tokenName, password);
        }
        throw new RuntimeException("KeyType: \"" + keyType + "\" is not allowed! Required \"file\" or \"token\".");
    }

    private String getModuleVersion() {
        Response<String> response = new Response<String>("200");
        response.setCode("200");
        response.setResponseObject(this.version.toString());
        return JSONObject.wrap(response).toString();
    }

    private String signXml(JSONObject requestJSON) {
        Response<String> response = new Response<String>("500");
        try {
            KeyLoader keyLoader = this.createKeyLoader(requestJSON);
            String xml = this.validateStringArgument(requestJSON, "xml");
            SigningEntity signingEntity = new SigningEntity(keyLoader.getPrivateKey(), Collections.singletonList(keyLoader.getCertificate()));
            String sign = XMLUtil.createXmlSignature((SigningEntity)signingEntity, (String)xml, (Provider)ProviderManager.getProvider());
            this.logService.log(3, "Success signing.");
            Thread.sleep(200L);
            response.setCode("200");
            response.setResponseObject(sign);
        }
        catch (Exception var13) {
            this.processError(var13, response);
        }
        return JSONObject.wrap(response).toString();
    }

    public void setLogService(LogService logService) {
        this.logService = logService;
    }

    public void setGuiService(GuiService guiService) {
        this.guiService = guiService;
    }

    public void setCommonUtils(CommonUtils commonUtils) {
        this.commonUtils = commonUtils;
    }

    public void setModuleVersion(Version version) {
        this.version = version;
    }
}

