/*
 * Decompiled with CFR 0.152.
 */
package kz.metadoc.ncamodule.osgi.swing.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EtchedBorder;
import kz.metadoc.ncamodule.osgi.Constants;
import kz.metadoc.ncamodule.osgi.swing.components.ImagePanel;

public class SignDataDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton showPasswordButon;
    private JPasswordField passwordField;
    private JButton okButton;
    private JButton cancelButton;

    public SignDataDialog(final Consumer<String> callback) {
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setTitle("\u041f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
        this.setBounds(100, 100, 450, 245);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        panel.setLayout(null);
        panel.setPreferredSize(new Dimension(450, 225));
        this.okButton = this.createOkButton(callback);
        panel.add(this.okButton);
        this.cancelButton = this.createCancelButton(callback);
        panel.add(this.cancelButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                callback.accept(null);
                SignDataDialog.this.dispose();
            }
        });
        JPanel mesPanel = new JPanel();
        mesPanel.setBorder(new EtchedBorder(1, null, null));
        mesPanel.setBounds(15, 15, 415, 85);
        panel.add(mesPanel);
        mesPanel.setLayout(null);
        JLabel mesLabel = new JLabel();
        mesLabel.setText("<html><p>\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c \u043d\u0430 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u043a\u043b\u044e\u0447\u0435\u0439:</p></html>");
        mesLabel.setForeground(Constants.BUTTON_BACKGROUND_COLOR);
        mesLabel.setFont(new Font("Tahoma", 1, 14));
        mesLabel.setHorizontalAlignment(0);
        mesLabel.setBounds(10, 0, 334, 85);
        mesPanel.add(mesLabel);
        this.passwordField = this.createPasswordField();
        panel.add(this.passwordField);
        JLabel warningText = new JLabel("");
        warningText.setFont(new Font("Tahoma", 0, 11));
        warningText.setForeground(Color.RED);
        warningText.setBounds(15, 103, 415, 14);
        panel.add(warningText);
        this.showPasswordButon = this.createShowPasswordButton();
        panel.add(this.showPasswordButon);
        ImagePanel imgPanel = new ImagePanel();
        imgPanel.setBounds(15, 124, 75, 75);
        panel.add(imgPanel);
        this.setFrameToScreenCenter();
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JPasswordField getPasswordField() {
        return this.passwordField;
    }

    private void setFrameToScreenCenter() {
        Dimension d = this.getToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
    }

    private JButton createShowPasswordButton() {
        JButton button = new JButton(new ImageIcon(SignDataDialog.class.getClassLoader().getResource("img/eye_16.png")));
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SignDataDialog.this.passwordField.setEchoChar('\u0000');
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SignDataDialog.this.passwordField.setEchoChar('*');
            }
        });
        button.setForeground(Constants.BUTTON_FOREGROUND_COLOR);
        button.setFont(new Font("Tahoma", 0, 14));
        button.setContentAreaFilled(false);
        button.setOpaque(true);
        button.setBackground(Constants.BUTTON_BACKGROUND_COLOR);
        button.setBounds(385, 124, 45, 30);
        return button;
    }

    private JPasswordField createPasswordField() {
        JPasswordField passwordField = new JPasswordField();
        passwordField.enableInputMethods(true);
        passwordField.setFont(new Font("Tahoma", 1, 14));
        passwordField.setBounds(100, 124, 285, 30);
        return passwordField;
    }

    private JButton createOkButton(Consumer<String> callback) {
        JButton button = new JButton("\u041f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c");
        button.addActionListener(x -> {
            callback.accept(new String(this.passwordField.getPassword()));
            this.dispose();
        });
        button.setForeground(Constants.BUTTON_FOREGROUND_COLOR);
        button.setFont(new Font("Tahoma", 0, 14));
        button.setContentAreaFilled(false);
        button.setOpaque(true);
        button.setBackground(Constants.BUTTON_BACKGROUND_COLOR);
        button.setBounds(100, 169, 155, 35);
        return button;
    }

    private JButton createCancelButton(Consumer<String> callback) {
        JButton button = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        button.addActionListener(x -> {
            callback.accept(null);
            this.dispose();
        });
        button.setForeground(Constants.BUTTON_FOREGROUND_COLOR);
        button.setFont(new Font("Tahoma", 0, 14));
        button.setContentAreaFilled(false);
        button.setOpaque(true);
        button.setBackground(Constants.BUTTON_BACKGROUND_COLOR);
        button.setBounds(275, 169, 155, 35);
        return button;
    }
}

